/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.builder.internal;

import com.easy.query.core.enums.EasyBehaviorEnum;
import com.easy.query.core.util.EasyBitwiseUtil;

public final class EasyBehavior {
    public static EasyBehavior DEFAULT = new EasyBehavior();
    public static int DEFAULT_BEHAVIOR = EasyBehaviorEnum.LOGIC_DELETE.getCode() | EasyBehaviorEnum.USE_INTERCEPTOR.getCode() | EasyBehaviorEnum.QUERY_LARGE_COLUMN.getCode() | EasyBehaviorEnum.JDBC_LISTEN.getCode();
    private int behavior = DEFAULT_BEHAVIOR;

    public boolean isDefaultBehavior() {
        return this.behavior == 0;
    }

    public boolean hasBehavior(EasyBehaviorEnum easyBehavior) {
        return EasyBitwiseUtil.hasBit(this.behavior, easyBehavior.getCode());
    }

    public boolean addBehavior(EasyBehaviorEnum easyBehavior) {
        if (this.hasBehavior(easyBehavior)) {
            return false;
        }
        this.behavior = EasyBitwiseUtil.addBit(this.behavior, easyBehavior.getCode());
        return true;
    }

    public boolean removeBehavior(EasyBehaviorEnum easyBehavior) {
        if (this.hasBehavior(easyBehavior)) {
            this.behavior = EasyBitwiseUtil.removeBit(this.behavior, easyBehavior.getCode());
            return true;
        }
        return false;
    }

    public void copyTo(EasyBehavior easyBehavior) {
        easyBehavior.behavior = this.behavior;
    }
}

