/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.expression.impl;

import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.expression.segment.condition.PredicateSegment;
import com.easy.query.core.expression.sql.builder.ExpressionBuilder;
import com.easy.query.core.expression.sql.expression.EntityQuerySQLExpression;
import com.easy.query.core.expression.sql.expression.EntityTableSQLExpression;
import com.easy.query.core.expression.sql.expression.SQLExpression;
import com.easy.query.core.expression.sql.expression.factory.ExpressionFactory;
import com.easy.query.core.expression.sql.expression.impl.EntitySQLExpressionMetadata;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasySQLExpressionUtil;
import com.easy.query.core.util.EasySQLSegmentUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QuerySQLExpressionImpl
implements EntityQuerySQLExpression {
    protected final EntitySQLExpressionMetadata entitySQLExpressionMetadata;
    protected SQLBuilderSegment projects;
    protected PredicateSegment where;
    protected SQLBuilderSegment group;
    protected PredicateSegment having;
    protected SQLBuilderSegment order;
    protected long offset;
    protected long rows;
    protected boolean distinct;
    protected final List<EntityTableSQLExpression> tables = new ArrayList<EntityTableSQLExpression>();
    protected List<EntityTableSQLExpression> relationTables;

    public QuerySQLExpressionImpl(EntitySQLExpressionMetadata entitySQLExpressionMetadata) {
        this.entitySQLExpressionMetadata = entitySQLExpressionMetadata;
    }

    @Override
    public EntitySQLExpressionMetadata getExpressionMetadata() {
        return this.entitySQLExpressionMetadata;
    }

    @Override
    public QueryRuntimeContext getRuntimeContext() {
        return this.entitySQLExpressionMetadata.getRuntimeContext();
    }

    @Override
    public SQLBuilderSegment getProjects() {
        return this.projects;
    }

    @Override
    public void setProjects(SQLBuilderSegment projects) {
        this.projects = projects;
    }

    @Override
    public PredicateSegment getWhere() {
        return this.where;
    }

    @Override
    public void setWhere(PredicateSegment where) {
        this.where = where;
    }

    @Override
    public SQLBuilderSegment getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(SQLBuilderSegment group) {
        this.group = group;
    }

    @Override
    public PredicateSegment getHaving() {
        return this.having;
    }

    @Override
    public void setHaving(PredicateSegment having) {
        this.having = having;
    }

    @Override
    public SQLBuilderSegment getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(SQLBuilderSegment order) {
        this.order = order;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public long getRows() {
        return this.rows;
    }

    @Override
    public void setRows(long rows) {
        this.rows = rows;
    }

    @Override
    public boolean hasLimit() {
        return this.rows > 0L;
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public List<EntityTableSQLExpression> getTables() {
        return this.tables;
    }

    @Override
    public List<EntityTableSQLExpression> getRelationTables() {
        if (this.relationTables == null) {
            this.relationTables = new ArrayList<EntityTableSQLExpression>();
        }
        return this.relationTables;
    }

    @Override
    public boolean hasRelationTables() {
        return EasyCollectionUtil.isNotEmpty(this.relationTables);
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        boolean root = EasySQLExpressionUtil.expressionInvokeRoot(toSQLContext);
        if (root && this.entitySQLExpressionMetadata.getExpressionContext().hasDeclareExpressions()) {
            StringBuilder sb = new StringBuilder();
            List<ExpressionBuilder> declareExpressions = this.entitySQLExpressionMetadata.getExpressionContext().getDeclareExpressions();
            for (ExpressionBuilder declareExpression : declareExpressions) {
                SQLExpression expression = declareExpression.toExpression();
                String sql = expression.toSQL(toSQLContext);
                sb.append(sql).append(" ");
            }
            sb.append(this.toSQL0(true, toSQLContext));
            return sb.toString();
        }
        return this.toSQL0(root, toSQLContext);
    }

    protected String toSQL0(boolean root, ToSQLContext toSQLContext) {
        StringBuilder sql = new StringBuilder("SELECT ");
        if (this.distinct) {
            sql.append("DISTINCT ");
        }
        sql.append(this.projects.toSQL(toSQLContext));
        List<EntityTableSQLExpression> tables = this.getTables();
        this.buildSQLTableOrJoin(sql, tables, toSQLContext);
        boolean hasWhere = EasySQLSegmentUtil.isNotEmpty(this.where);
        if (hasWhere) {
            String whereSQL = this.where.toSQL(toSQLContext);
            sql.append(" WHERE ").append(whereSQL);
        }
        if (this.group != null && this.group.isNotEmpty()) {
            sql.append(" GROUP BY ").append(this.group.toSQL(toSQLContext));
        }
        if (this.having != null && this.having.isNotEmpty()) {
            sql.append(" HAVING ").append(this.having.toSQL(toSQLContext));
        }
        if (this.order != null && this.order.isNotEmpty()) {
            sql.append(" ORDER BY ").append(this.order.toSQL(toSQLContext));
        }
        if (this.rows > 0L) {
            sql.append(" LIMIT ");
            sql.append(this.rows);
            if (this.offset > 0L) {
                sql.append(" OFFSET ").append(this.offset);
            }
        }
        return sql.toString();
    }

    protected void buildSQLTableOrJoin(StringBuilder sql, List<EntityTableSQLExpression> tables, ToSQLContext toSQLContext) {
        if (EasyCollectionUtil.isSingle(tables)) {
            EntityTableSQLExpression firstTable = tables.get(0);
            sql.append(firstTable.toSQL(toSQLContext));
        } else {
            Iterator<EntityTableSQLExpression> iterator = this.getTables().iterator();
            EntityTableSQLExpression firstTable = iterator.next();
            sql.append(firstTable.toSQL(toSQLContext));
            while (iterator.hasNext()) {
                EntityTableSQLExpression table = iterator.next();
                sql.append(table.toSQL(toSQLContext));
                PredicateSegment on = table.getOn();
                if (on == null || !on.isNotEmpty()) continue;
                sql.append(" ON ").append(on.toSQL(toSQLContext));
            }
        }
    }

    @Override
    public EntityQuerySQLExpression cloneSQLExpression() {
        ExpressionFactory expressionFactory = this.getRuntimeContext().getExpressionFactory();
        EntityQuerySQLExpression easyQuerySQLExpression = expressionFactory.createEasyQuerySQLExpression(this.entitySQLExpressionMetadata);
        if (EasySQLSegmentUtil.isNotEmpty(this.where)) {
            easyQuerySQLExpression.setWhere(this.where.clonePredicateSegment());
        }
        if (EasySQLSegmentUtil.isNotEmpty(this.group)) {
            easyQuerySQLExpression.setGroup(this.group.cloneSQLBuilder());
        }
        if (EasySQLSegmentUtil.isNotEmpty(this.having)) {
            easyQuerySQLExpression.setHaving(this.having.clonePredicateSegment());
        }
        if (EasySQLSegmentUtil.isNotEmpty(this.order)) {
            easyQuerySQLExpression.setOrder(this.order.cloneSQLBuilder());
        }
        if (EasySQLSegmentUtil.isNotEmpty(this.projects)) {
            easyQuerySQLExpression.setProjects(this.projects.cloneSQLBuilder());
        }
        easyQuerySQLExpression.setOffset(this.offset);
        easyQuerySQLExpression.setRows(this.rows);
        for (EntityTableSQLExpression table : this.tables) {
            easyQuerySQLExpression.getTables().add(table.cloneSQLExpression());
        }
        if (this.hasRelationTables()) {
            for (EntityTableSQLExpression relationTable : this.relationTables) {
                easyQuerySQLExpression.getRelationTables().add(relationTable.cloneSQLExpression());
            }
        }
        return easyQuerySQLExpression;
    }
}

