/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.expression.impl;

import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.configuration.dialect.SQLKeyword;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.MultiTableTypeEnum;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.condition.PredicateSegment;
import com.easy.query.core.expression.sql.expression.EntityTableSQLExpression;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.util.EasySQLExpressionUtil;
import com.easy.query.core.util.EasySQLSegmentUtil;
import com.easy.query.core.util.EasyToSQLUtil;
import java.util.function.BiFunction;
import java.util.function.Function;

public class TableSQLExpressionImpl
implements EntityTableSQLExpression {
    protected final MultiTableTypeEnum multiTableType;
    protected final QueryRuntimeContext runtimeContext;
    protected final SQLKeyword SQLKeyWord;
    protected final TableAvailable entityTable;
    protected PredicateSegment on;
    protected Function<String, String> tableNameAs;
    protected Function<String, String> schemaAs;
    protected Function<String, String> linkAs;
    protected BiFunction<String, String, String> segmentAs;

    public TableSQLExpressionImpl(TableAvailable entityTable, MultiTableTypeEnum multiTableType, QueryRuntimeContext runtimeContext) {
        this.entityTable = entityTable;
        this.multiTableType = multiTableType;
        this.runtimeContext = runtimeContext;
        this.SQLKeyWord = runtimeContext.getQueryConfiguration().getDialect();
    }

    @Override
    public EntityMetadata getEntityMetadata() {
        return this.entityTable.getEntityMetadata();
    }

    @Override
    public TableAvailable getEntityTable() {
        return this.entityTable;
    }

    public Function<String, String> getTableNameAs() {
        return this.tableNameAs;
    }

    @Override
    public void setTableNameAs(Function<String, String> tableNameAs) {
        this.tableNameAs = tableNameAs;
    }

    @Override
    public void setSchemaAs(Function<String, String> schemaAs) {
        this.schemaAs = schemaAs;
    }

    @Override
    public void setLinkAs(Function<String, String> linkAs) {
        this.linkAs = linkAs;
    }

    @Override
    public void setTableSegmentAs(BiFunction<String, String, String> segmentAs) {
        this.segmentAs = segmentAs;
    }

    @Override
    public boolean tableNameIsAs() {
        return this.tableNameAs != null;
    }

    public String getSelectTableSource() {
        if (this.linkAs != null) {
            return this.linkAs.apply(this.multiTableType.getAppendSQL());
        }
        return this.multiTableType.getAppendSQL();
    }

    @Override
    public String getTableName() {
        return EasyToSQLUtil.getSchemaTableName(this.SQLKeyWord, this.entityTable.getEntityMetadata(), this.entityTable.getTableName(), this.schemaAs, this.tableNameAs);
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        boolean none;
        EasySQLExpressionUtil.expressionInvokeRoot(toSQLContext);
        EasySQLExpressionUtil.tableSQLExpressionRewrite(toSQLContext, this);
        StringBuilder sql = new StringBuilder();
        boolean bl = none = MultiTableTypeEnum.NONE == this.multiTableType;
        if (!none) {
            sql.append(" ");
        }
        sql.append(this.getSelectTableSource());
        if (!none) {
            sql.append(" ");
        }
        sql.append(this.getTableSegment(toSQLContext));
        return sql.toString();
    }

    private String getTableSegment(ToSQLContext toSQLContext) {
        String tableName = this.getTableName();
        String tableAlias = EasySQLExpressionUtil.getTableAlias(toSQLContext, this.entityTable);
        if (this.segmentAs != null) {
            return this.segmentAs.apply(tableName, tableAlias);
        }
        StringBuilder sql = new StringBuilder();
        sql.append(tableName);
        if (tableAlias != null) {
            sql.append(" ").append(tableAlias);
        }
        return sql.toString();
    }

    @Override
    public PredicateSegment getOn() {
        return this.on;
    }

    @Override
    public void setOn(PredicateSegment predicateSegment) {
        this.on = predicateSegment;
    }

    @Override
    public EntityTableSQLExpression cloneSQLExpression() {
        EntityTableSQLExpression tableSQLExpression = this.runtimeContext.getExpressionFactory().createEntityTableSQLExpression(this.entityTable, this.multiTableType, this.runtimeContext);
        if (EasySQLSegmentUtil.isNotEmpty(this.on)) {
            PredicateSegment predicateSegment = this.on.clonePredicateSegment();
            tableSQLExpression.setOn(predicateSegment);
        }
        tableSQLExpression.setTableNameAs(this.tableNameAs);
        tableSQLExpression.setSchemaAs(this.schemaAs);
        tableSQLExpression.setLinkAs(this.linkAs);
        return tableSQLExpression;
    }
}

