/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.include;

import com.easy.query.core.basic.api.select.ClientQueryable;
import com.easy.query.core.basic.api.select.executor.MapAble;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.RelationTypeEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.lambda.SQLFuncExpression;
import com.easy.query.core.expression.lambda.SQLFuncExpression1;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.parser.core.base.ColumnSelector;
import com.easy.query.core.expression.segment.ColumnSegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.expression.sql.builder.AnonymousEntityTableExpressionBuilder;
import com.easy.query.core.expression.sql.builder.EntityQueryExpressionBuilder;
import com.easy.query.core.expression.sql.builder.EntityTableExpressionBuilder;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.expression.sql.include.ColumnIncludeExpression;
import com.easy.query.core.expression.sql.include.DefaultIncludeParserResult;
import com.easy.query.core.expression.sql.include.IncludeParseContext;
import com.easy.query.core.expression.sql.include.IncludeParserEngine;
import com.easy.query.core.expression.sql.include.IncludeParserResult;
import com.easy.query.core.expression.sql.include.RelationExtraEntity;
import com.easy.query.core.expression.sql.include.RelationExtraEntityImpl;
import com.easy.query.core.expression.sql.include.multi.RelationValueColumnMetadata;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.IncludeNavigateExpression;
import com.easy.query.core.metadata.IncludeNavigateParams;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.metadata.RelationExtraColumn;
import com.easy.query.core.metadata.RelationExtraMetadata;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyIncludeUtil;
import com.easy.query.core.util.EasySQLExpressionUtil;
import com.easy.query.core.util.EasyStringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DefaultIncludeParserEngine
implements IncludeParserEngine {
    private <TEntity> List<RelationExtraEntity> getRelationExtraEntities(ExpressionContext expressionContext, List<TEntity> entities) {
        if (EasyCollectionUtil.isEmpty(entities)) {
            return new ArrayList<RelationExtraEntity>();
        }
        ArrayList<RelationExtraEntity> relationExtraEntities = new ArrayList<RelationExtraEntity>(entities.size());
        EntityMetadata entityMetadata = expressionContext.getRuntimeContext().getEntityMetadataManager().getEntityMetadata(entities.get(0).getClass());
        RelationExtraMetadata relationExtraMetadata = expressionContext.getRelationExtraMetadata();
        Map<String, RelationExtraColumn> relationExtraColumnMap = relationExtraMetadata.getRelationExtraColumnMap();
        Map<String, RelationExtraColumn> extraColumnMetadata = relationExtraColumnMap.values().stream().map(o -> {
            if (o.isAppendRelationExtra()) {
                return o;
            }
            ColumnMetadata columnMetadata = entityMetadata.getColumnNotNull(o.getPropertyName());
            return new RelationExtraColumn(o.getPropertyName(), o.getColumnName(), columnMetadata, o.isAppendRelationExtra());
        }).collect(Collectors.toMap(o -> o.getPropertyName(), o -> o, (k1, k2) -> k1));
        int i = 0;
        for (TEntity entity : entities) {
            Map<String, Object> extraColumns = relationExtraMetadata.getRelationExtraColumnList().get(i);
            RelationExtraEntityImpl relationExtraEntity = new RelationExtraEntityImpl(entity, extraColumns, extraColumnMetadata, expressionContext.getRuntimeContext().getRelationValueFactory());
            relationExtraEntities.add(relationExtraEntity);
            ++i;
        }
        return relationExtraEntities;
    }

    @Override
    public <TR> IncludeParserResult process(ExpressionContext expressionContext, EntityMetadata entityMetadata, List<TR> result, IncludeNavigateExpression includeExpression) {
        IncludeNavigateParams includeNavigateParams = includeExpression.getIncludeNavigateParams();
        SQLFuncExpression<ClientQueryable<?>> queryableExpression = includeExpression.getSqlFuncExpression();
        NavigateMetadata navigateMetadata = includeNavigateParams.getNavigateMetadata();
        if (navigateMetadata == null) {
            throw new EasyQueryInvalidOperationException("navigateMetadata is null");
        }
        QueryRuntimeContext runtimeContext = expressionContext.getRuntimeContext();
        List<RelationExtraEntity> relationExtraEntities = this.getRelationExtraEntities(expressionContext, result);
        IncludeParseContext includeParseContext = new IncludeParseContext(includeNavigateParams);
        includeParseContext.setIncludeQueryableExpression(queryableExpression);
        includeParseContext.setIncludeMappingQueryableFunction(includeNavigateParams.getMappingQueryableFunction());
        includeParseContext.setSelfProperties(navigateMetadata.getSelfPropertiesOrPrimary());
        includeParseContext.setTargetProperties(navigateMetadata.getTargetPropertiesOrPrimary(runtimeContext));
        boolean aliasEntity = !Objects.equals(entityMetadata.getEntityClass(), navigateMetadata.getEntityMetadata().getEntityClass());
        this.confirmNavigateProperty(aliasEntity, expressionContext, entityMetadata, includeNavigateParams, includeParseContext);
        if (EasyStringUtil.isBlank(includeParseContext.getNavigatePropertyName())) {
            throw new EasyQueryInvalidOperationException("not found relation navigate property");
        }
        List<List<Object>> relationIds = relationExtraEntities.stream().map(o -> o.getRelationExtraColumns(navigateMetadata.getSelfPropertiesOrPrimary())).filter(o -> !o.isNull()).distinct().map(o -> o.getValues()).collect(Collectors.toList());
        int queryRelationGroupSize = includeNavigateParams.getQueryRelationGroupSize();
        if (RelationTypeEnum.ManyToMany == navigateMetadata.getRelationType() && navigateMetadata.getMappingClass() != null) {
            this.confirmMappingRows(queryRelationGroupSize, includeParseContext, relationIds);
            EntityMetadata mappingEntityMetadata = runtimeContext.getEntityMetadataManager().getEntityMetadata(navigateMetadata.getMappingClass());
            RelationValueColumnMetadata relationValueColumnMetadata = runtimeContext.getRelationValueFactory().create(mappingEntityMetadata, navigateMetadata.getTargetMappingProperties());
            List targetIds = includeParseContext.getMappingRows().stream().map(relationValueColumnMetadata::getRelationValue).filter(o -> !o.isNull()).distinct().map(o -> o.getValues()).collect(Collectors.toList());
            relationIds.clear();
            relationIds.addAll(targetIds);
        }
        List<RelationExtraEntity> includeResult = EasyIncludeUtil.queryableExpressionGroupExecute(queryRelationGroupSize, includeParseContext.getIncludeQueryableExpression(), includeNavigateParams, relationIds, q -> {
            ExpressionContext innerExpressionContext = q.getSQLEntityExpressionBuilder().getExpressionContext();
            List list = q.toList();
            return this.getRelationExtraEntities(innerExpressionContext, list);
        });
        return new DefaultIncludeParserResult(entityMetadata, relationExtraEntities, navigateMetadata.getRelationType(), includeParseContext.getNavigatePropertyName(), includeParseContext.getNavigateOriginalPropertyType(), includeParseContext.getNavigatePropertyType(), includeParseContext.getSelfProperties(), includeParseContext.getTargetProperties(), includeParseContext.getIncludeNavigateParams().getNavigateMetadata().getMappingClass(), includeParseContext.getIncludeNavigateParams().getNavigateMetadata().getSelfMappingProperties(), includeParseContext.getIncludeNavigateParams().getNavigateMetadata().getTargetMappingProperties(), includeResult, includeParseContext.getMappingRows(), includeParseContext.getNavigatePropertySetter(), includeParseContext.getNavigatePropertyGetter(), includeParseContext.getIncludeNavigateParams().getNavigateFlatMetadataList(), includeParseContext.getIncludeNavigateParams().getFlatQueryEntityMetadata());
    }

    private void confirmMappingRows(int queryRelationGroupSize, IncludeParseContext includeParseContext, List<List<Object>> relationIds) {
        IncludeNavigateParams includeNavigateParams = includeParseContext.getIncludeNavigateParams();
        List<Map<String, Object>> mappingRows = EasyIncludeUtil.queryableExpressionGroupExecute(queryRelationGroupSize, includeNavigateParams.getMappingQueryableFunction(), includeNavigateParams, relationIds, MapAble::toMaps);
        includeParseContext.setMappingRows(mappingRows);
    }

    private <T> List<T> executeQueryableAndClearParams(ClientQueryable<?> mappingQueryable, IncludeNavigateParams includeNavigateParams, SQLFuncExpression1<ClientQueryable<?>, List<T>> produce) {
        List<T> result = produce.apply(mappingQueryable);
        includeNavigateParams.getRelationIds().clear();
        return result;
    }

    private void confirmNavigateProperty(boolean aliasEntity, ExpressionContext expressionContext, EntityMetadata entityMetadata, IncludeNavigateParams includeNavigateParams, IncludeParseContext includeParseContext) {
        boolean hasColumnIncludeMaps = expressionContext.hasColumnIncludeMaps();
        if (hasColumnIncludeMaps) {
            String propertyName;
            ColumnIncludeExpression columnIncludeExpression;
            Map<String, ColumnIncludeExpression> propertyColumnIncludeExpressionMap = expressionContext.getColumnIncludeMaps().get(includeNavigateParams.getTable());
            if (propertyColumnIncludeExpressionMap != null && (columnIncludeExpression = propertyColumnIncludeExpressionMap.get(propertyName = includeParseContext.getIncludeNavigateParams().getNavigateMetadata().getPropertyName())) != null) {
                NavigateMetadata selfNavigateMetadata = includeNavigateParams.getNavigateMetadata();
                NavigateMetadata aliasNavigateMetadata = entityMetadata.getNavigateNotNull(columnIncludeExpression.getAliasProperty());
                if (includeParseContext.getIncludeNavigateParams().getNavigateMetadata().getRelationType() != aliasNavigateMetadata.getRelationType()) {
                    throw new EasyQueryInvalidOperationException("select alias relation type different property:[" + aliasNavigateMetadata.getPropertyName() + "]");
                }
                includeParseContext.setNavigatePropertyName(aliasNavigateMetadata.getPropertyName());
                includeParseContext.setNavigatePropertyType(aliasNavigateMetadata.getNavigatePropertyType());
                includeParseContext.setNavigateOriginalPropertyType(aliasNavigateMetadata.getNavigateOriginalPropertyType());
                includeParseContext.setNavigatePropertySetter(aliasNavigateMetadata.getSetter());
                includeParseContext.setNavigatePropertyGetter(aliasNavigateMetadata.getGetter());
                SQLFuncExpression<ClientQueryable<?>> includeQueryableExpression = includeParseContext.getIncludeQueryableExpression();
                if (columnIncludeExpression.getIncludeSelectorExpression() == null) {
                    includeParseContext.setIncludeQueryableExpression(() -> {
                        ClientQueryable includeQueryable = (ClientQueryable)includeQueryableExpression.apply();
                        EntityQueryExpressionBuilder sqlEntityExpressionBuilder = includeQueryable.getSQLEntityExpressionBuilder();
                        Class<?> aliasClassType = includeParseContext.getIncludeNavigateParams().getFlatClassType() == null ? aliasNavigateMetadata.getNavigatePropertyType() : includeParseContext.getIncludeNavigateParams().getFlatClassType();
                        includeQueryable.select(aliasClassType, t -> {
                            t.columnAll();
                            EasySQLExpressionUtil.appendTargetExtraTargetProperty(selfNavigateMetadata, sqlEntityExpressionBuilder, t.getSQLNative(), t.getTable());
                        });
                        return includeQueryable;
                    });
                } else {
                    includeParseContext.setIncludeQueryableExpression(() -> {
                        ClientQueryable includeQueryable = (ClientQueryable)includeQueryableExpression.apply();
                        EntityQueryExpressionBuilder sqlEntityExpressionBuilder = includeQueryable.getSQLEntityExpressionBuilder();
                        Class<?> aliasClassType = includeParseContext.getIncludeNavigateParams().getFlatClassType() == null ? aliasNavigateMetadata.getNavigatePropertyType() : includeParseContext.getIncludeNavigateParams().getFlatClassType();
                        return includeQueryable.select(aliasClassType, t -> {
                            columnIncludeExpression.getIncludeSelectorExpression().apply(t.getAsSelector());
                            EasySQLExpressionUtil.appendSelfExtraTargetProperty(sqlEntityExpressionBuilder, t.getSQLNative(), t.getTable());
                            EasySQLExpressionUtil.appendTargetExtraTargetProperty(selfNavigateMetadata, sqlEntityExpressionBuilder, t.getSQLNative(), t.getTable());
                        });
                    });
                }
                return;
            }
        } else {
            SQLFuncExpression<ClientQueryable<?>> includeQueryableExpression = includeParseContext.getIncludeQueryableExpression();
            includeParseContext.setIncludeQueryableExpression(() -> {
                ClientQueryable includeQueryable = (ClientQueryable)includeQueryableExpression.apply();
                EntityQueryExpressionBuilder sqlEntityExpressionBuilder = includeQueryable.getSQLEntityExpressionBuilder();
                NavigateMetadata navigateMetadata = includeNavigateParams.getNavigateMetadata();
                if (sqlEntityExpressionBuilder.getProjects().isEmpty()) {
                    Class<?> aliasClassType = includeParseContext.getIncludeNavigateParams().getFlatClassType();
                    if (aliasClassType != null) {
                        return includeQueryable.select(aliasClassType, t -> {
                            t.columnAll();
                            EasySQLExpressionUtil.appendTargetExtraTargetProperty(navigateMetadata, sqlEntityExpressionBuilder, t.getSQLNative(), t.getTable());
                        });
                    }
                    return includeQueryable.select(t -> {
                        t.columnAll();
                        EasySQLExpressionUtil.appendTargetExtraTargetProperty(navigateMetadata, sqlEntityExpressionBuilder, t.getSQLNative(), t.getTable());
                    });
                }
                ColumnSelector columnSelector = includeQueryable.getSQLExpressionProvider1().getColumnSelector(sqlEntityExpressionBuilder.getProjects());
                EasySQLExpressionUtil.appendTargetExtraTargetProperty(navigateMetadata, sqlEntityExpressionBuilder, columnSelector.getSQLNative(), columnSelector.getTable());
                return includeQueryable;
            });
        }
        if (!aliasEntity || includeNavigateParams.isMappingFlat()) {
            NavigateMetadata navigateMetadata = includeNavigateParams.getNavigateMetadata();
            includeParseContext.setNavigatePropertyName(navigateMetadata.getPropertyName());
            includeParseContext.setNavigateOriginalPropertyType(navigateMetadata.getNavigateOriginalPropertyType());
            includeParseContext.setNavigatePropertyType(navigateMetadata.getNavigatePropertyType());
            includeParseContext.setNavigatePropertySetter(navigateMetadata.getSetter());
            includeParseContext.setNavigatePropertyGetter(navigateMetadata.getGetter());
        }
    }

    private String getColumnNameByColumnSegments(EntityQueryExpressionBuilder entityQueryExpressionBuilder, TableAvailable table, String selfProperty) {
        for (SQLSegment sqlSegment : entityQueryExpressionBuilder.getProjects().getSQLSegments()) {
            ColumnSegment columnSegment;
            if (!(sqlSegment instanceof ColumnSegment) || !Objects.equals((columnSegment = (ColumnSegment)sqlSegment).getTable(), table) || !Objects.equals(columnSegment.getPropertyName(), selfProperty)) continue;
            if (columnSegment.getAlias() != null) {
                return columnSegment.getAlias();
            }
            return columnSegment.getTable().getColumnName(selfProperty);
        }
        return null;
    }

    private String getColumnNameByQueryExpressionBuilder(EntityQueryExpressionBuilder entityQueryExpressionBuilder, TableAvailable table, String propertyName) {
        String columnName = null;
        for (EntityTableExpressionBuilder entityQueryExpressionBuilderTable : entityQueryExpressionBuilder.getTables()) {
            if (columnName != null) break;
            if (Objects.equals(entityQueryExpressionBuilderTable.getEntityTable(), table)) {
                columnName = this.getColumnNameByColumnSegments(entityQueryExpressionBuilder, table, propertyName);
            }
            if (columnName != null || !(entityQueryExpressionBuilderTable instanceof AnonymousEntityTableExpressionBuilder)) continue;
            AnonymousEntityTableExpressionBuilder anonymousEntityTableExpressionBuilder = (AnonymousEntityTableExpressionBuilder)entityQueryExpressionBuilderTable;
            EntityQueryExpressionBuilder anonymousEntityQueryExpressionBuilder = anonymousEntityTableExpressionBuilder.getEntityQueryExpressionBuilder();
            columnName = this.getColumnNameByQueryExpressionBuilder(anonymousEntityQueryExpressionBuilder, table, propertyName);
        }
        return columnName;
    }
}

