/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.expression.sql.include;

import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.sql.include.RelationExtraEntity;
import com.easy.query.core.expression.sql.include.RelationValue;
import com.easy.query.core.expression.sql.include.multi.RelationValueFactory;
import com.easy.query.core.metadata.RelationExtraColumn;
import com.easy.query.core.util.EasyClassUtil;
import java.util.Map;
import java.util.Objects;

public class RelationExtraEntityImpl
implements RelationExtraEntity {
    private final Object entity;
    private final Map<String, Object> extraColumns;
    private final Map<String, RelationExtraColumn> relationExtraColumnMap;
    private final RelationValueFactory relationValueFactory;

    public RelationExtraEntityImpl(Object entity, Map<String, Object> extraColumns, Map<String, RelationExtraColumn> relationExtraColumnMap, RelationValueFactory relationValueFactory) {
        this.relationExtraColumnMap = relationExtraColumnMap;
        this.relationValueFactory = relationValueFactory;
        Objects.requireNonNull(entity, "entity is null");
        Objects.requireNonNull(extraColumns, "extraColumns is null");
        this.entity = entity;
        this.extraColumns = extraColumns;
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    @Override
    public RelationValue getRelationExtraColumns(String[] propertyNames) {
        Object[] values = new Object[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            values[i] = this.getRelationExtraColumn(propertyNames[i]);
        }
        return this.relationValueFactory.createRelationValue(values);
    }

    private Object getRelationExtraColumn(String propertyName) {
        RelationExtraColumn relationExtraColumn = this.relationExtraColumnMap.get(propertyName);
        if (relationExtraColumn == null) {
            throw new EasyQueryInvalidOperationException(EasyClassUtil.getInstanceSimpleName(this.entity) + " cant get relation column:" + propertyName);
        }
        if (relationExtraColumn.isAppendRelationExtra()) {
            return this.extraColumns.get(propertyName);
        }
        return relationExtraColumn.getColumnMetadata().getGetterCaller().apply(this.entity);
    }
}

