/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.extension.casewhen;

import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.common.tuple.Tuple2;
import com.easy.query.core.expression.builder.Filter;
import com.easy.query.core.expression.builder.core.AnyValueFilter;
import com.easy.query.core.expression.builder.impl.FilterImpl;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.segment.CloneableSQLSegment;
import com.easy.query.core.expression.segment.condition.AndPredicateSegment;
import com.easy.query.core.expression.segment.scec.expression.ParamExpression;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.util.EasySQLExpressionUtil;
import java.util.ArrayList;
import java.util.List;

public class CaseWhenSQLColumnSegment
implements CloneableSQLSegment {
    private final ExpressionContext expressionContext;
    private final List<Tuple2<SQLExpression1<Filter>, ParamExpression>> whens;
    private final ParamExpression elseValue;

    public CaseWhenSQLColumnSegment(ExpressionContext expressionContext, List<Tuple2<SQLExpression1<Filter>, ParamExpression>> whens, ParamExpression elseValue) {
        this.expressionContext = expressionContext;
        this.whens = whens;
        this.elseValue = elseValue;
    }

    @Override
    public CloneableSQLSegment cloneSQLColumnSegment() {
        return new CaseWhenSQLColumnSegment(this.expressionContext, new ArrayList<Tuple2<SQLExpression1<Filter>, ParamExpression>>(this.whens), this.elseValue);
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        StringBuilder sql = new StringBuilder();
        sql.append("(CASE ");
        for (Tuple2<SQLExpression1<Filter>, ParamExpression> when : this.whens) {
            SQLExpression1<Filter> filterExpression = when.t();
            ParamExpression paramExpression = when.t1();
            AndPredicateSegment resolve = this.resolve(filterExpression);
            String caseWhenPredicateSql = resolve.toSQL(toSQLContext);
            Object thenValue = EasySQLExpressionUtil.parseParamExpression(this.expressionContext, paramExpression, toSQLContext);
            sql.append("WHEN ").append(caseWhenPredicateSql).append(" THEN ").append(thenValue).append(" ");
        }
        Object elseValue = EasySQLExpressionUtil.parseParamExpression(this.expressionContext, this.elseValue, toSQLContext);
        sql.append("ELSE ").append(elseValue).append(" END)");
        return sql.toString();
    }

    public AndPredicateSegment resolve(SQLExpression1<Filter> filterExpression) {
        AndPredicateSegment andPredicateSegment = new AndPredicateSegment(true);
        FilterImpl filter = new FilterImpl(this.expressionContext.getRuntimeContext(), this.expressionContext, andPredicateSegment, false, AnyValueFilter.DEFAULT);
        filterExpression.apply(filter);
        return andPredicateSegment;
    }
}

