/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.func.def;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.parser.core.base.scec.core.SQLNativeChainExpressionContext;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.func.SQLFunction;
import com.easy.query.core.func.SQLFunctionTranslateImpl;
import com.easy.query.core.func.column.ColumSQLExpression;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.column.ColumnFuncFormatExpression;
import com.easy.query.core.func.column.ColumnFuncValueExpression;
import com.easy.query.core.func.column.ColumnFunctionExpression;
import com.easy.query.core.func.column.ColumnKeepStyleExpression;
import com.easy.query.core.func.column.ColumnLazyFunctionExpression;
import com.easy.query.core.func.column.ColumnMultiValueExpression;
import com.easy.query.core.func.column.ColumnPropertyExpression;
import com.easy.query.core.func.column.ColumnSubQueryExpression;
import com.easy.query.core.func.def.AbstractSQLFunction;
import com.easy.query.core.util.EasyClassUtil;
import java.util.List;

public abstract class AbstractExpressionSQLFunction
extends AbstractSQLFunction {
    protected abstract List<ColumnExpression> getColumnExpressions();

    @Override
    protected void consume0(SQLNativeChainExpressionContext context) {
        this.invokeExpression(context);
    }

    protected void invokeExpression(SQLNativeChainExpressionContext context) {
        for (ColumnExpression concatExpression : this.getColumnExpressions()) {
            this.invokeExpression0(context, concatExpression);
        }
    }

    protected void invokeExpression0(SQLNativeChainExpressionContext context, ColumnExpression columnExpression) {
        if (columnExpression instanceof ColumnPropertyExpression) {
            ColumnPropertyExpression concatColumnExpression = (ColumnPropertyExpression)columnExpression;
            TableAvailable tableOrNull = concatColumnExpression.getTableOrNull();
            if (tableOrNull == null) {
                context.expression(concatColumnExpression.getProperty());
            } else {
                context.expression(tableOrNull, concatColumnExpression.getProperty());
            }
        } else if (columnExpression instanceof ColumnKeepStyleExpression) {
            context.keepStyle();
        } else if (columnExpression instanceof ColumnFuncValueExpression) {
            ColumnFuncValueExpression concatValueExpression = (ColumnFuncValueExpression)columnExpression;
            context.value(concatValueExpression.getValue());
        } else if (columnExpression instanceof ColumnMultiValueExpression) {
            ColumnMultiValueExpression columnMultiValueExpression = (ColumnMultiValueExpression)columnExpression;
            context.collection(columnMultiValueExpression.getValues());
        } else if (columnExpression instanceof ColumnFuncFormatExpression) {
            ColumnFuncFormatExpression concatFormatExpression = (ColumnFuncFormatExpression)columnExpression;
            context.format(concatFormatExpression.getFormat());
        } else if (columnExpression instanceof ColumSQLExpression) {
            ColumSQLExpression columSQLExpression = (ColumSQLExpression)columnExpression;
            context.sql(columSQLExpression.getSQLSegment());
        } else if (columnExpression instanceof ColumnFunctionExpression) {
            ColumnFunctionExpression columnFunctionExpression = (ColumnFunctionExpression)columnExpression;
            TableAvailable tableOrNull = columnFunctionExpression.getTableOrNull();
            TableAvailable sqlFunctionTable = tableOrNull == null ? context.getDefaultTable() : tableOrNull;
            SQLSegment sqlSegment = new SQLFunctionTranslateImpl(columnFunctionExpression.getSQLFunction()).toSQLSegment(context.getExpressionContext(), sqlFunctionTable, context.getRuntimeContext(), null);
            context.sql(sqlSegment);
        } else if (columnExpression instanceof ColumnLazyFunctionExpression) {
            ColumnLazyFunctionExpression columnFunctionExpression = (ColumnLazyFunctionExpression)columnExpression;
            TableAvailable tableOrNull = columnFunctionExpression.getTableOrNull();
            TableAvailable sqlFunctionTable = tableOrNull == null ? context.getDefaultTable() : tableOrNull;
            SQLFunction sqlFunction = columnFunctionExpression.getSQLFunctionCreator().apply(context.getRuntimeContext().fx());
            SQLSegment sqlSegment = new SQLFunctionTranslateImpl(sqlFunction).toSQLSegment(context.getExpressionContext(), sqlFunctionTable, context.getRuntimeContext(), null);
            context.sql(sqlSegment);
        } else if (columnExpression instanceof ColumnSubQueryExpression) {
            ColumnSubQueryExpression columnSubQueryExpression = (ColumnSubQueryExpression)columnExpression;
            context.expression(columnSubQueryExpression.getQuery());
        } else {
            throw new UnsupportedOperationException(EasyClassUtil.getInstanceSimpleName(columnExpression));
        }
    }
}

