/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.func.def.impl;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import com.easy.query.core.util.EasyClassUtil;
import java.util.List;

public class CastSQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final Class<?> targetClass;

    public CastSQLFunction(List<ColumnExpression> columnExpressions, Class<?> targetClass) {
        this.columnExpressions = columnExpressions;
        this.targetClass = targetClass;
    }

    @Override
    public String sqlSegment(TableAvailable defaultTable) {
        String targetClassName;
        switch (targetClassName = EasyClassUtil.getFullName(this.targetClass)) {
            case "boolean": 
            case "java.lang.Boolean": {
                return "({0} NOT IN ('0','false'))";
            }
            case "char": {
                return "SUBSTR(CAST({0} AS CHAR), 1, 1)";
            }
            case "java.sql.Time": 
            case "java.time.Time": {
                return "CAST({0} AS TIME)";
            }
            case "java.sql.Date": 
            case "java.time.LocalDate": {
                return "CAST({0} AS DATE)";
            }
            case "java.sql.Timestamp": 
            case "java.util.Date": 
            case "java.time.LocalDateTime": {
                return "CAST({0} AS DATETIME)";
            }
            case "java.math.BigDecimal": {
                return "CAST({0} AS DECIMAL(36,18))";
            }
            case "double": 
            case "float": 
            case "java.lang.Float": 
            case "java.lang.Double": {
                return "CAST({0} AS DECIMAL(32,16))";
            }
            case "byte": 
            case "short": 
            case "int": 
            case "long": 
            case "java.lang.Byte": 
            case "java.lang.Short": 
            case "java.lang.Integer": 
            case "java.lang.Long": {
                return "CAST({0} AS SIGNED)";
            }
            case "java.util.UUID": {
                return "SUBSTR(CAST({0} AS CHAR), 1, 36)";
            }
            case "java.lang.String": {
                return "CAST({0} AS CHAR)";
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5f53\u524d\u8f6c\u6362\u51fd\u6570:" + targetClassName);
    }

    @Override
    public int paramMarks() {
        return this.columnExpressions.size();
    }

    @Override
    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

