/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.func.def.impl;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import com.easy.query.core.func.def.enums.TimeUnitEnum;
import java.util.List;

public class DateTime2PlusSQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final TimeUnitEnum timeUnit;

    public DateTime2PlusSQLFunction(List<ColumnExpression> columnExpressions, TimeUnitEnum timeUnit) {
        this.columnExpressions = columnExpressions;
        this.timeUnit = timeUnit;
    }

    @Override
    public String sqlSegment(TableAvailable defaultTable) {
        if (this.columnExpressions.size() != 2) {
            throw new IllegalArgumentException("columnExpressions.size() != 2");
        }
        switch (this.timeUnit) {
            case MILLISECONDS: {
                return "date_add({0}, interval ({1})*1000 microsecond)";
            }
            case SECONDS: {
                return "date_add({0}, interval ({1}) second)";
            }
            case MINUTES: {
                return "date_add({0}, interval ({1}) minute)";
            }
            case HOURS: {
                return "date_add({0}, interval ({1}) hour)";
            }
            case DAYS: {
                return "date_add({0}, interval ({1}) day)";
            }
            case MONTHS: {
                return "date_add({0}, interval ({1}) month)";
            }
            case YEARS: {
                return "date_add({0}, interval ({1}) year)";
            }
        }
        throw new UnsupportedOperationException("not support current function DateTime2PlusSQLFunction:" + (Object)((Object)this.timeUnit));
    }

    @Override
    public int paramMarks() {
        return this.columnExpressions.size();
    }

    @Override
    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

