/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.func.def.impl;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import com.easy.query.core.func.def.enums.DateTimeDurationEnum;
import java.util.List;

public class DateTimeDurationSQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final DateTimeDurationEnum durationEnum;

    public DateTimeDurationSQLFunction(List<ColumnExpression> columnExpressions, DateTimeDurationEnum durationEnum) {
        this.columnExpressions = columnExpressions;
        this.durationEnum = durationEnum;
    }

    @Override
    public String sqlSegment(TableAvailable defaultTable) {
        if (this.columnExpressions.size() != 2) {
            throw new IllegalArgumentException("date time duration sql arguments != 2");
        }
        switch (this.durationEnum) {
            case Days: {
                return "timestampdiff(DAY, {1}, {0})";
            }
            case Hours: {
                return "timestampdiff(HOUR, {1}, {0})";
            }
            case Minutes: {
                return "timestampdiff(MINUTE, {1}, {0})";
            }
            case Seconds: {
                return "timestampdiff(SECOND, {1}, {0})";
            }
        }
        throw new UnsupportedOperationException("not support current function DateTimeDurationSQLFunction:" + (Object)((Object)this.durationEnum));
    }

    @Override
    public int paramMarks() {
        return this.columnExpressions.size();
    }

    @Override
    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

