/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.func.def.impl;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import com.easy.query.core.func.def.enums.DateTimeUnitEnum;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.List;

public class DateTimePropertySQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final DateTimeUnitEnum dateTimeUnitEnum;

    public DateTimePropertySQLFunction(List<ColumnExpression> columnExpressions, DateTimeUnitEnum dateTimeUnitEnum) {
        this.columnExpressions = columnExpressions;
        this.dateTimeUnitEnum = dateTimeUnitEnum;
    }

    @Override
    public String sqlSegment(TableAvailable defaultTable) {
        if (EasyCollectionUtil.isEmpty(this.columnExpressions)) {
            throw new IllegalArgumentException("columnExpressions is empty");
        }
        switch (this.dateTimeUnitEnum) {
            case DayOfYear: {
                return "DAYOFYEAR({0})";
            }
            case DayOfWeek: {
                return "(DAYOFWEEK({0})-1)";
            }
            case Year: {
                return "YEAR({0})";
            }
            case Month: {
                return "MONTH({0})";
            }
            case Day: {
                return "DAYOFMONTH({0})";
            }
            case Hour: {
                return "HOUR({0})";
            }
            case Minute: {
                return "MINUTE({0})";
            }
            case Second: {
                return "SECOND({0})";
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5f53\u524d\u5c5e\u6027\u83b7\u53d6:" + (Object)((Object)this.dateTimeUnitEnum));
    }

    @Override
    public int paramMarks() {
        return this.columnExpressions.size();
    }

    @Override
    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

