/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.func.def.impl;

import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.SQLFunction;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.column.impl.ColumnFunctionExpressionImpl;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import com.easy.query.core.func.def.PartitionBySQLFunction;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.List;

public class RowNumberOverSQLFunction
extends AbstractExpressionSQLFunction
implements PartitionBySQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final int partitionByColumnSize;

    public RowNumberOverSQLFunction(List<ColumnExpression> columnExpressions) {
        if (EasyCollectionUtil.isEmpty(columnExpressions)) {
            throw new EasyQueryInvalidOperationException("row_number partition by empty");
        }
        this.columnExpressions = columnExpressions;
        this.partitionByColumnSize = columnExpressions.size();
    }

    @Override
    public String sqlSegment(TableAvailable defaultTable) {
        int i;
        StringBuilder sql = new StringBuilder();
        sql.append("(ROW_NUMBER() OVER (PARTITION BY ");
        for (i = 0; i < this.partitionByColumnSize; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append("{").append(i).append("}");
        }
        if (this.columnExpressions.size() > this.partitionByColumnSize) {
            sql.append(" ORDER BY ");
            for (i = this.partitionByColumnSize; i < this.columnExpressions.size(); ++i) {
                if (i > this.partitionByColumnSize) {
                    sql.append(", ");
                }
                sql.append("{").append(i).append("}");
            }
        }
        sql.append("))");
        return sql.toString();
    }

    @Override
    public int paramMarks() {
        return this.columnExpressions.size();
    }

    @Override
    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }

    @Override
    public PartitionBySQLFunction addOrder(SQLFunction sqlFunction) {
        ColumnFunctionExpressionImpl columnFunctionExpression = new ColumnFunctionExpressionImpl(null, sqlFunction);
        this.columnExpressions.add(columnFunctionExpression);
        return this;
    }
}

