/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.func.def.impl;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.def.AbstractSubStringExpressionSQLFunction;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.ArrayList;
import java.util.List;

public class SubStringSQLFunction
extends AbstractSubStringExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions = new ArrayList<ColumnExpression>(3);

    public SubStringSQLFunction(List<ColumnExpression> columnExpressions) {
        if (columnExpressions.size() != 3) {
            throw new UnsupportedOperationException("substring sql function must have 3 params");
        }
        for (int i = 0; i < columnExpressions.size(); ++i) {
            ColumnExpression columnExpression = columnExpressions.get(i);
            if (i == 1) {
                this.columnExpressions.add(this.getBeginColumnExpression(columnExpression));
                continue;
            }
            this.columnExpressions.add(columnExpression);
        }
    }

    @Override
    public String sqlSegment(TableAvailable defaultTable) {
        List<String> params = EasyCollectionUtil.select(this.columnExpressions, (t, i) -> "{" + i + "}");
        return String.format("SUBSTR(%s)", String.join((CharSequence)",", params));
    }

    @Override
    public int paramMarks() {
        return this.columnExpressions.size();
    }

    @Override
    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

