/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.func.def.impl;

import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.SQLFunction;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.column.impl.ColumnFunctionExpressionImpl;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import com.easy.query.core.func.def.PartitionBySQLFunction;
import java.util.List;

public class SumOverSQLFunction
extends AbstractExpressionSQLFunction
implements PartitionBySQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final int partitionByColumnSizePlusOne;

    public SumOverSQLFunction(List<ColumnExpression> columnExpressions) {
        this.columnExpressions = columnExpressions;
        this.partitionByColumnSizePlusOne = columnExpressions.size();
    }

    @Override
    public String sqlSegment(TableAvailable defaultTable) {
        int i;
        if (this.columnExpressions.size() < 2) {
            throw new EasyQueryInvalidOperationException("sum over columnExpressions < 2");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("(SUM({0}) OVER (PARTITION BY ");
        for (i = 1; i < this.partitionByColumnSizePlusOne; ++i) {
            if (i > 1) {
                sql.append(", ");
            }
            sql.append("{").append(i).append("}");
        }
        if (this.columnExpressions.size() > this.partitionByColumnSizePlusOne) {
            sql.append(" ORDER BY ");
            for (i = this.partitionByColumnSizePlusOne; i < this.columnExpressions.size(); ++i) {
                if (i > this.partitionByColumnSizePlusOne) {
                    sql.append(", ");
                }
                sql.append("{").append(i).append("}");
            }
        }
        sql.append("))");
        return sql.toString();
    }

    @Override
    public int paramMarks() {
        return this.columnExpressions.size();
    }

    @Override
    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }

    @Override
    public PartitionBySQLFunction addOrder(SQLFunction sqlFunction) {
        ColumnFunctionExpressionImpl columnFunctionExpression = new ColumnFunctionExpressionImpl(null, sqlFunction);
        this.columnExpressions.add(columnFunctionExpression);
        return this;
    }
}

