/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.inject.impl;

import com.easy.query.core.inject.BeanCurrentlyInjectMarker;
import com.easy.query.core.inject.ServiceDescriptor;
import com.easy.query.core.inject.ServiceProvider;
import com.easy.query.core.util.EasyClassUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ServiceProviderImpl
implements ServiceProvider {
    private final Map<Class<?>, ServiceDescriptor> servicesMapping;
    private final Map<Class<?>, Object> services;
    private final BeanCurrentlyInjectMarker beanCurrentlyInjectMarker;

    public ServiceProviderImpl(Map<Class<?>, ServiceDescriptor> servicesMapping) {
        this.servicesMapping = servicesMapping;
        this.beanCurrentlyInjectMarker = new BeanCurrentlyInjectMarker();
        this.services = new ConcurrentHashMap(servicesMapping.size() + 1);
        this.services.put(ServiceProvider.class, this);
    }

    @Override
    public <T> T getService(Class<T> serviceType) {
        Object service = this.getServiceObject0(serviceType);
        return serviceType.cast(service);
    }

    @Override
    public Object getServiceObject(Class<?> serviceType) {
        return this.getServiceObject0(serviceType);
    }

    private Object getServiceObject0(Class<?> serviceType) {
        Object service = this.services.get(serviceType);
        if (service == null) {
            ServiceDescriptor serviceDescriptor = this.servicesMapping.get(serviceType);
            if (serviceDescriptor == null) {
                throw new IllegalArgumentException("Service not found for type " + serviceType.getName());
            }
            Object o = this.resolveByServiceDescriptor(serviceDescriptor);
            this.beanCurrentlyInjectMarker.beanCreated(serviceDescriptor);
            this.services.putIfAbsent(serviceType, o);
            service = this.services.get(serviceType);
        }
        return service;
    }

    private Object resolveByServiceDescriptor(ServiceDescriptor serviceDescriptor) {
        this.beanCurrentlyInjectMarker.beanCreateMark(serviceDescriptor);
        if (serviceDescriptor.getImplementationInstance() != null) {
            return serviceDescriptor.getImplementationInstance();
        }
        if (serviceDescriptor.getImplementationFactory() != null) {
            return serviceDescriptor.getImplementationFactory().apply(this);
        }
        if (serviceDescriptor.getImplementationType() != null) {
            return this.createInstance(serviceDescriptor.getImplementationType());
        }
        throw new IllegalArgumentException("cant to resolve service type " + EasyClassUtil.getSimpleName(serviceDescriptor.getServiceType()));
    }

    private Object createInstance(Class<?> serviceType) {
        try {
            Constructor<?>[] constructors = serviceType.getConstructors();
            if (constructors.length != 1) {
                throw new IllegalArgumentException("Service type " + serviceType.getName() + " must have a single public constructor.");
            }
            Constructor<?> constructor = constructors[0];
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            Object[] arguments = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                arguments[i] = this.getService(parameterTypes[i]);
            }
            return serviceType.cast(constructor.newInstance(arguments));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to create instance of service type " + EasyClassUtil.getSimpleName(serviceType), e);
        }
    }
}

