/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.logging;

import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.nologging.NoLoggingImpl;
import com.easy.query.core.logging.stdout.StdOutImpl;
import java.lang.reflect.Constructor;

public class LogFactory {
    public static final String MARKER = "EASYQUERY";
    private static Constructor<? extends Log> logConstructor;

    private LogFactory() {
    }

    public static Log getLog(Class<?> clazz) {
        return LogFactory.getLog(clazz.getName());
    }

    public static Log getLog(String logger) {
        try {
            return logConstructor.newInstance(logger);
        }
        catch (Throwable t) {
            throw new EasyQueryException("Error creating logger for logger " + logger + ".  Cause: " + t, t);
        }
    }

    public static synchronized void useCustomLogging(Class<? extends Log> clazz) {
        LogFactory.setImplementation(clazz);
    }

    public static synchronized void useStdOutLogging() {
        LogFactory.setImplementation(StdOutImpl.class);
    }

    public static synchronized void useNoLogging() {
        LogFactory.setImplementation(NoLoggingImpl.class);
    }

    private static void tryImplementation(Runnable runnable) {
        if (logConstructor == null) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void setImplementation(Class<? extends Log> implClass) {
        try {
            Constructor<? extends Log> candidate = implClass.getConstructor(String.class);
            Log log = candidate.newInstance(LogFactory.class.getName());
            if (log.isDebugEnabled()) {
                log.debug("Logging initialized using '" + implClass + "' adapter.");
            }
            logConstructor = candidate;
        }
        catch (Throwable t) {
            throw new EasyQueryException("Error setting Log implementation.  Cause: " + t, t);
        }
    }

    static {
        LogFactory.tryImplementation(LogFactory::useNoLogging);
    }
}

