/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.metadata;

import com.easy.query.core.common.MapColumnNameChecker;
import com.easy.query.core.common.cache.Cache;
import com.easy.query.core.common.cache.DefaultMemoryCache;
import com.easy.query.core.inject.ServiceProvider;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.EntityMetadataManager;
import com.easy.query.core.metadata.MapEntityMetadata;
import java.util.Map;

public class DefaultEntityMetadataManager
implements EntityMetadataManager {
    private final Cache<Class<?>, EntityMetadata> entityMetadataCache = new DefaultMemoryCache();
    private final ServiceProvider serviceProvider;
    private final MapColumnNameChecker mapColumnNameChecker;

    public DefaultEntityMetadataManager(ServiceProvider serviceProvider, MapColumnNameChecker mapColumnNameChecker) {
        this.serviceProvider = serviceProvider;
        this.mapColumnNameChecker = mapColumnNameChecker;
    }

    @Override
    public EntityMetadata getEntityMetadata(Class<?> entityClass) {
        if (entityClass == null) {
            throw new IllegalArgumentException("entityClass");
        }
        EntityMetadata cacheItem = this.entityMetadataCache.get(entityClass);
        if (cacheItem != null) {
            return cacheItem;
        }
        if (Map.class.isAssignableFrom(entityClass)) {
            return this.entityMetadataCache.computeIfAbsent(entityClass, key -> new MapEntityMetadata(Map.class, this.mapColumnNameChecker));
        }
        EntityMetadata entityMetadata = new EntityMetadata(entityClass);
        entityMetadata.init(this.serviceProvider);
        return this.entityMetadataCache.computeIfAbsent(entityClass, key -> entityMetadata);
    }

    @Override
    public boolean isSharding(Class<?> entityClass) {
        EntityMetadata entityMetadata = this.getEntityMetadata(entityClass);
        return entityMetadata.isMultiTableMapping() || entityMetadata.isMultiDataSourceMapping();
    }

    @Override
    public boolean isShardingTable(Class<?> entityClass) {
        EntityMetadata entityMetadata = this.getEntityMetadata(entityClass);
        return entityMetadata.isMultiTableMapping();
    }

    @Override
    public boolean isOnlyShardingTable(Class<?> entityClass) {
        EntityMetadata entityMetadata = this.getEntityMetadata(entityClass);
        return entityMetadata.isMultiTableMapping() && !entityMetadata.isMultiDataSourceMapping();
    }

    @Override
    public boolean isShardingDataSource(Class<?> entityClass) {
        EntityMetadata entityMetadata = this.getEntityMetadata(entityClass);
        return entityMetadata.isMultiDataSourceMapping();
    }

    @Override
    public boolean isOnlyShardingDataSource(Class<?> entityClass) {
        EntityMetadata entityMetadata = this.getEntityMetadata(entityClass);
        return entityMetadata.isMultiDataSourceMapping() && !entityMetadata.isMultiTableMapping();
    }
}

