/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.metadata;

import com.easy.query.core.metadata.NavigateFlatMetadata;
import com.easy.query.core.metadata.NavigateFlatProperty;
import java.util.List;
import java.util.stream.Collectors;

public class MappingPathIterator {
    private final List<NavigateFlatMetadata> navigateFlatMetadataList;
    private int index;
    private final int maxLength;

    public MappingPathIterator(List<NavigateFlatMetadata> navigateFlatMetadataList) {
        this.navigateFlatMetadataList = navigateFlatMetadataList;
        this.maxLength = navigateFlatMetadataList.stream().map(x -> x.getMappingPath().length).max(Integer::compareTo).orElse(0);
        this.index = 0;
    }

    public boolean hasNext() {
        return this.index < this.maxLength;
    }

    public List<NavigateFlatProperty> next() {
        List<NavigateFlatProperty> flatProperties = this.navigateFlatMetadataList.stream().filter(o -> this.index < o.getMappingPath().length).map(o -> new NavigateFlatProperty((NavigateFlatMetadata)o, o.getMappingPath()[this.index], o.getMappingPath().length - 1 - this.index)).collect(Collectors.toList());
        ++this.index;
        return flatProperties;
    }

    public List<NavigateFlatProperty> nextRest() {
        return this.navigateFlatMetadataList.stream().filter(o -> this.index < o.getMappingPath().length).map(o -> new NavigateFlatProperty((NavigateFlatMetadata)o, o.getMappingPath()[this.index], o.getMappingPath().length - 1 - this.index)).collect(Collectors.toList());
    }

    public boolean hasOneNext() {
        return this.index == this.navigateFlatMetadataList.size() - 1;
    }

    public List<NavigateFlatMetadata> getNavigateFlatMetadataList() {
        return this.navigateFlatMetadataList;
    }
}

