/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.metadata;

import com.easy.query.core.metadata.NavigateFlatMetadata;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.ArrayList;
import java.util.List;

public class MappingPathTreeNode {
    private String name;
    private List<NavigateFlatMetadata> navigateFlatMetadataList;
    private List<MappingPathTreeNode> children;
    private int flatBasicCount;
    private int deep = 0;

    public MappingPathTreeNode(String name) {
        this.name = name;
        this.navigateFlatMetadataList = new ArrayList<NavigateFlatMetadata>();
        this.children = new ArrayList<MappingPathTreeNode>();
    }

    public MappingPathTreeNode findChild(String name) {
        for (MappingPathTreeNode child : this.children) {
            if (!child.name.equals(name)) continue;
            return child;
        }
        return null;
    }

    public void addChild(MappingPathTreeNode child) {
        this.children.add(child);
    }

    public void printTree(String prefix) {
        System.out.println(prefix + this.name);
        for (MappingPathTreeNode child : this.children) {
            child.printTree(prefix + "--");
        }
    }

    public List<MappingPathTreeNode> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return EasyCollectionUtil.isNotEmpty(this.children);
    }

    public String getName() {
        return this.name;
    }

    public List<NavigateFlatMetadata> getNavigateFlatMetadataList() {
        return this.navigateFlatMetadataList;
    }

    public void addNavigateFlatMetadata(NavigateFlatMetadata navigateFlatMetadata) {
        if (navigateFlatMetadata.isBasicType()) {
            ++this.flatBasicCount;
        }
        this.navigateFlatMetadataList.add(navigateFlatMetadata);
    }

    public boolean anyBasicType() {
        return this.flatBasicCount > 0;
    }

    public boolean allBasicType(int size) {
        return this.flatBasicCount == size;
    }

    public int getDeep() {
        return this.deep;
    }

    public void setDeep(int deep) {
        this.deep = deep;
    }
}

