/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.metadata;

import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.RelationTypeEnum;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.expression.lambda.PropertySetterCaller;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.parser.core.base.WherePredicate;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.NavigateOption;
import com.easy.query.core.metadata.NavigateOrderProp;
import com.easy.query.core.util.EasyArrayUtil;
import java.util.List;

public class NavigateMetadata {
    private final EntityMetadata entityMetadata;
    private final String propertyName;
    private final Class<?> navigateOriginalPropertyType;
    private final Class<?> navigatePropertyType;
    private final RelationTypeEnum relationType;
    private final boolean basicType;
    private final List<NavigateOrderProp> orderProps;
    private final String[] selfProperties;
    private final String[] targetProperties;
    private final Property<Object, ?> getter;
    private final PropertySetterCaller<Object> setter;
    private final Class<?> mappingClass;
    private final String[] selfMappingProperties;
    private final String[] targetMappingProperties;
    private final SQLExpression1<WherePredicate<?>> predicateFilterExpression;
    private final SQLExpression1<WherePredicate<?>> predicateMappingClassFilterExpression;
    private final long offset;
    private final long limit;

    public NavigateMetadata(NavigateOption navigateOption, Property<Object, ?> getter, PropertySetterCaller<Object> setter) {
        this.entityMetadata = navigateOption.getEntityMetadata();
        this.propertyName = navigateOption.getPropertyName();
        this.navigateOriginalPropertyType = navigateOption.getNavigateOriginalPropertyType();
        this.navigatePropertyType = navigateOption.getNavigatePropertyType();
        this.relationType = navigateOption.getRelationType();
        this.selfProperties = navigateOption.getSelfProperties();
        this.targetProperties = navigateOption.getTargetProperties();
        this.mappingClass = navigateOption.getMappingClass();
        this.selfMappingProperties = navigateOption.getSelfMappingProperties();
        this.targetMappingProperties = navigateOption.getTargetMappingProperties();
        this.predicateFilterExpression = navigateOption.getPredicateFilterExpression();
        this.predicateMappingClassFilterExpression = navigateOption.getPredicateMappingClassFilterExpression();
        this.basicType = navigateOption.isBasicType();
        this.orderProps = navigateOption.getOrderProps();
        this.offset = navigateOption.getOffset();
        this.limit = navigateOption.getLimit();
        this.getter = getter;
        this.setter = setter;
    }

    public EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getNavigatePropertyType() {
        return this.navigatePropertyType;
    }

    public Class<?> getNavigateOriginalPropertyType() {
        return this.navigateOriginalPropertyType;
    }

    public RelationTypeEnum getRelationType() {
        return this.relationType;
    }

    public String[] getSelfProperties() {
        return this.selfProperties;
    }

    public String[] getSelfPropertiesOrPrimary() {
        if (EasyArrayUtil.isNotEmpty(this.selfProperties)) {
            return this.selfProperties;
        }
        return new String[]{this.entityMetadata.getSingleKeyProperty()};
    }

    public String[] getTargetProperties() {
        return this.targetProperties;
    }

    public String[] getTargetPropertiesOrPrimary(QueryRuntimeContext runtimeContext) {
        if (EasyArrayUtil.isNotEmpty(this.targetProperties)) {
            return this.targetProperties;
        }
        EntityMetadata targetEntityMetadata = runtimeContext.getEntityMetadataManager().getEntityMetadata(this.navigatePropertyType);
        return new String[]{targetEntityMetadata.getSingleKeyProperty()};
    }

    public Class<?> getMappingClass() {
        return this.mappingClass;
    }

    public String[] getSelfMappingProperties() {
        return this.selfMappingProperties;
    }

    public String[] getTargetMappingProperties() {
        return this.targetMappingProperties;
    }

    public Property<Object, ?> getGetter() {
        return this.getter;
    }

    public PropertySetterCaller<Object> getSetter() {
        return this.setter;
    }

    public ColumnMetadata[] getSelfRelationColumn() {
        String[] selfPropertyNames = this.getSelfPropertiesOrPrimary();
        ColumnMetadata[] columnMetadatas = new ColumnMetadata[selfPropertyNames.length];
        for (int i = 0; i < selfPropertyNames.length; ++i) {
            ColumnMetadata column;
            columnMetadatas[i] = column = this.entityMetadata.getColumnNotNull(selfPropertyNames[i]);
        }
        return columnMetadatas;
    }

    public SQLExpression1<WherePredicate<?>> getPredicateFilterExpression() {
        return this.predicateFilterExpression;
    }

    public boolean hasPredicateFilterExpression() {
        return this.predicateFilterExpression != null;
    }

    public void predicateFilterApply(WherePredicate<?> wherePredicate) {
        if (this.predicateFilterExpression != null) {
            this.predicateFilterExpression.apply(wherePredicate);
        }
    }

    public SQLExpression1<WherePredicate<?>> getPredicateMappingClassFilterExpression() {
        return this.predicateMappingClassFilterExpression;
    }

    public boolean hasPredicateMappingClassFilterExpression() {
        return this.predicateMappingClassFilterExpression != null;
    }

    public void predicateMappingClassFilterApply(WherePredicate<?> wherePredicate) {
        if (this.predicateMappingClassFilterExpression != null) {
            this.predicateMappingClassFilterExpression.apply(wherePredicate);
        }
    }

    public boolean isBasicType() {
        return this.basicType;
    }

    public List<NavigateOrderProp> getOrderProps() {
        return this.orderProps;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }
}

