/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.metadata;

import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PropertyDescriptorFinder {
    private final boolean mapFind;
    private final PropertyDescriptor[] propertyDescriptors;
    private Map<String, PropertyDescriptor> propertyDescriptorMap;

    public PropertyDescriptorFinder(PropertyDescriptor[] propertyDescriptors) {
        boolean bl = this.mapFind = propertyDescriptors.length > 5;
        if (this.mapFind) {
            this.propertyDescriptorMap = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                this.propertyDescriptorMap.put(propertyDescriptor.getName(), propertyDescriptor);
            }
        }
        this.propertyDescriptors = propertyDescriptors;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public PropertyDescriptor find(String propertyName) {
        if (this.mapFind) {
            return this.propertyDescriptorMap.get(propertyName);
        }
        return this.firstOrNull(this.propertyDescriptors, (PropertyDescriptor o) -> Objects.equals(o.getName(), propertyName));
    }

    public PropertyDescriptor findIgnoreCase(String propertyName) {
        if (propertyName == null) {
            throw new EasyQueryInvalidOperationException("propertyName is null");
        }
        if (this.mapFind) {
            return this.firstOrNull(this.propertyDescriptorMap, (PropertyDescriptor o) -> propertyName.equalsIgnoreCase(o.getName()));
        }
        return this.firstOrNull(this.propertyDescriptors, (PropertyDescriptor o) -> propertyName.equalsIgnoreCase(o.getName()));
    }

    private PropertyDescriptor firstOrNull(PropertyDescriptor[] ps, Predicate<PropertyDescriptor> predicate) {
        for (PropertyDescriptor p : ps) {
            if (!predicate.test(p)) continue;
            return p;
        }
        return null;
    }

    private PropertyDescriptor firstOrNull(Map<String, PropertyDescriptor> propertyDescriptorMap, Predicate<PropertyDescriptor> predicate) {
        for (PropertyDescriptor p : propertyDescriptorMap.values()) {
            if (!predicate.test(p)) continue;
            return p;
        }
        return null;
    }
}

