/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.metadata;

import com.easy.query.core.enums.ExecuteMethodEnum;
import com.easy.query.core.enums.sharding.ConnectionModeEnum;
import com.easy.query.core.sharding.router.table.TableUnit;
import com.easy.query.core.util.EasyBitwiseUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ShardingSequenceConfig {
    private final Comparator<TableUnit> tableComparator;
    private final int sequenceCompareMethods;
    private final int sequenceCompareAscMethods;
    private final int sequenceLimitMethods;
    private final int sequenceConnectionModeMethods;
    private final ConnectionModeEnum connectionMode;
    private final int maxShardingQueryLimit;
    private final Map<String, Boolean> sequenceProperties;

    public ShardingSequenceConfig(Comparator<TableUnit> tableComparator, Map<String, Boolean> sequenceProperties, int maxShardingQueryLimit, int sequenceCompareMethods, int sequenceCompareAscMethods, int sequenceLimitMethods, int sequenceConnectionModeMethods, ConnectionModeEnum connectionMode) {
        this.tableComparator = tableComparator;
        this.maxShardingQueryLimit = maxShardingQueryLimit;
        this.sequenceCompareMethods = sequenceCompareMethods;
        this.sequenceCompareAscMethods = sequenceCompareAscMethods;
        this.sequenceLimitMethods = sequenceLimitMethods;
        this.sequenceConnectionModeMethods = sequenceConnectionModeMethods;
        this.connectionMode = connectionMode;
        this.sequenceProperties = sequenceProperties != null ? new HashMap<String, Boolean>(sequenceProperties) : Collections.emptyMap();
    }

    public Comparator<TableUnit> getTableComparator() {
        return this.tableComparator;
    }

    public ConnectionModeEnum getConnectionModeOrDefault(ExecuteMethodEnum executeMethod, ConnectionModeEnum def) {
        if (this.connectionMode == null) {
            return def;
        }
        if (!this.hasConnectionModeMethods(executeMethod)) {
            return def;
        }
        return this.connectionMode;
    }

    public int getMaxShardingQueryLimitOrDefault(ExecuteMethodEnum executeMethod, int def) {
        if (this.maxShardingQueryLimit <= 0) {
            return def;
        }
        if (!this.hasLimitMethods(executeMethod)) {
            return def;
        }
        return this.maxShardingQueryLimit;
    }

    public Boolean getSequenceProperty(String propertyName) {
        return this.sequenceProperties.get(propertyName);
    }

    public String getFirstSequencePropertyOrNull() {
        Set<Map.Entry<String, Boolean>> entries = this.sequenceProperties.entrySet();
        Map.Entry<String, Boolean> firstPropertyKv = EasyCollectionUtil.firstOrNull(entries);
        if (firstPropertyKv != null) {
            return firstPropertyKv.getKey();
        }
        return null;
    }

    public boolean hasCompareMethods(ExecuteMethodEnum executeMethod) {
        return EasyBitwiseUtil.hasBit(this.sequenceCompareMethods, executeMethod.getCode());
    }

    public boolean hasCompareAscMethods(ExecuteMethodEnum executeMethod) {
        return EasyBitwiseUtil.hasBit(this.sequenceCompareAscMethods, executeMethod.getCode());
    }

    public boolean hasLimitMethods(ExecuteMethodEnum executeMethod) {
        return EasyBitwiseUtil.hasBit(this.sequenceLimitMethods, executeMethod.getCode());
    }

    public boolean hasConnectionModeMethods(ExecuteMethodEnum executeMethod) {
        return EasyBitwiseUtil.hasBit(this.sequenceConnectionModeMethods, executeMethod.getCode());
    }
}

