/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.migration;

import com.easy.query.core.annotation.Column;
import com.easy.query.core.annotation.NotNull;
import com.easy.query.core.annotation.Nullable;
import com.easy.query.core.annotation.Table;
import com.easy.query.core.configuration.dialect.SQLKeyword;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.migration.ColumnDbTypeResult;
import com.easy.query.core.migration.DatabaseMigrationProvider;
import com.easy.query.core.migration.DefaultMigrationEntityParser;
import com.easy.query.core.migration.EntityMigrationMetadata;
import com.easy.query.core.migration.MigrationCommand;
import com.easy.query.core.migration.MigrationEntityParser;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyDatabaseUtil;
import com.easy.query.core.util.EasyStringUtil;
import com.easy.query.core.util.EasyToSQLUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;

public abstract class AbstractDatabaseMigrationProvider
implements DatabaseMigrationProvider {
    public static final String newLine = System.lineSeparator();
    protected final DataSource dataSource;
    protected final SQLKeyword sqlKeyword;
    protected String databaseName;
    protected MigrationEntityParser migrationEntityParser;

    public AbstractDatabaseMigrationProvider(DataSource dataSource, SQLKeyword sqlKeyword) {
        this.dataSource = dataSource;
        this.sqlKeyword = sqlKeyword;
        this.migrationEntityParser = new DefaultMigrationEntityParser();
    }

    @Override
    public void setMigrationParser(MigrationEntityParser migrationParser) {
        this.migrationEntityParser = migrationParser;
    }

    @Override
    public EntityMigrationMetadata createEntityMigrationMetadata(EntityMetadata entityMetadata) {
        return new EntityMigrationMetadata(entityMetadata);
    }

    @Override
    public String getDatabaseName() {
        if (this.databaseName == null) {
            this.databaseName = EasyDatabaseUtil.getDatabaseName(this.dataSource, null);
        }
        if (this.databaseName == null) {
            throw new EasyQueryInvalidOperationException("cant get database name, Please confirm that the database has been created and exists.");
        }
        return this.databaseName;
    }

    @Override
    public void createDatabaseIfNotExists() {
        EasyDatabaseUtil.checkAndCreateDatabase(this.dataSource, databaseName -> {
            this.databaseName = databaseName;
            return this.databaseExistSQL((String)databaseName);
        }, databaseName -> this.createDatabaseSQL((String)databaseName));
    }

    public abstract String databaseExistSQL(String var1);

    public abstract String createDatabaseSQL(String var1);

    @Override
    @NotNull
    public ColumnDbTypeResult getColumnDbType(EntityMigrationMetadata entityMigrationMetadata, ColumnMetadata columnMetadata) {
        String dbType;
        ColumnDbTypeResult columnDbType = this.migrationEntityParser.getColumnDbType(entityMigrationMetadata, columnMetadata);
        if (columnDbType != null) {
            return columnDbType;
        }
        Field declaredField = entityMigrationMetadata.getFieldByName(columnMetadata);
        Column annotation = declaredField.getAnnotation(Column.class);
        if (annotation != null && EasyStringUtil.isNotBlank(dbType = annotation.dbType())) {
            return new ColumnDbTypeResult(dbType, null);
        }
        ColumnDbTypeResult columnDbType0 = this.getColumnDbType0(entityMigrationMetadata, columnMetadata);
        if (columnDbType0 == null) {
            throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName(entityMigrationMetadata.getEntityMetadata().getEntityClass()) + "] field name:" + columnMetadata.getFieldName() + " not found column db type.");
        }
        return columnDbType0;
    }

    protected abstract ColumnDbTypeResult getColumnDbType0(EntityMigrationMetadata var1, ColumnMetadata var2);

    @Override
    public String getColumnComment(EntityMigrationMetadata entityMigrationMetadata, ColumnMetadata columnMetadata, String quote) {
        String columnComment = this.getColumnComment0(entityMigrationMetadata, columnMetadata);
        if (EasyStringUtil.isNotBlank(columnComment)) {
            return quote + columnComment + quote;
        }
        return null;
    }

    public String getColumnComment0(EntityMigrationMetadata entityMigrationMetadata, ColumnMetadata columnMetadata) {
        String comment;
        String columnComment = this.migrationEntityParser.getColumnComment(entityMigrationMetadata, columnMetadata);
        if (EasyStringUtil.isNotBlank(columnComment)) {
            return columnComment;
        }
        Field declaredField = entityMigrationMetadata.getFieldByName(columnMetadata);
        Column annotation = declaredField.getAnnotation(Column.class);
        if (annotation != null && EasyStringUtil.isNotBlank(comment = annotation.comment())) {
            return comment;
        }
        return this.getFieldComment(entityMigrationMetadata, columnMetadata.getFieldName());
    }

    protected String getFieldComment(EntityMigrationMetadata entityMigrationMetadata, String fieldName) {
        return entityMigrationMetadata.getFieldComment(fieldName);
    }

    @Override
    public boolean isNullable(EntityMigrationMetadata entityMigrationMetadata, ColumnMetadata columnMetadata) {
        if (columnMetadata.isPrimary()) {
            return false;
        }
        Boolean nullable = this.migrationEntityParser.isNullable(entityMigrationMetadata, columnMetadata);
        if (nullable != null) {
            return nullable;
        }
        Field declaredField = entityMigrationMetadata.getFieldByName(columnMetadata);
        Column annotation = declaredField.getAnnotation(Column.class);
        if (annotation != null) {
            return annotation.nullable();
        }
        return !columnMetadata.getPropertyType().isPrimitive();
    }

    @Override
    public boolean columnExistInDb(EntityMigrationMetadata entityMigrationMetadata, ColumnMetadata columnMetadata) {
        Boolean exist = this.migrationEntityParser.columnExistInDb(entityMigrationMetadata, columnMetadata);
        if (exist != null) {
            return exist;
        }
        Field declaredField = entityMigrationMetadata.getFieldByName(columnMetadata);
        Column annotation = declaredField.getAnnotation(Column.class);
        if (annotation != null) {
            return annotation.exist();
        }
        return true;
    }

    @Override
    @Nullable
    public String getTableComment(EntityMigrationMetadata entityMigrationMetadata, String quote) {
        String tableComment = this.getTableComment0(entityMigrationMetadata);
        if (EasyStringUtil.isNotBlank(tableComment)) {
            return quote + tableComment + quote;
        }
        return tableComment;
    }

    @Nullable
    protected String getTableComment0(EntityMigrationMetadata entityMigrationMetadata) {
        String comment;
        String tableComment = this.migrationEntityParser.getTableComment(entityMigrationMetadata);
        if (EasyStringUtil.isNotBlank(tableComment)) {
            return tableComment;
        }
        EntityMetadata entityMetadata = entityMigrationMetadata.getEntityMetadata();
        Table annotation = entityMetadata.getEntityClass().getAnnotation(Table.class);
        if (annotation != null && EasyStringUtil.isNotBlank(comment = annotation.comment())) {
            return comment;
        }
        return null;
    }

    @Override
    public String getColumnRenameFrom(EntityMigrationMetadata entityMigrationMetadata, ColumnMetadata columnMetadata) {
        String renameFrom;
        String columnRenameFrom = this.migrationEntityParser.getColumnRenameFrom(entityMigrationMetadata, columnMetadata);
        if (EasyStringUtil.isNotBlank(columnRenameFrom)) {
            return columnRenameFrom;
        }
        Field declaredField = entityMigrationMetadata.getFieldByName(columnMetadata);
        Column annotation = declaredField.getAnnotation(Column.class);
        if (annotation != null && EasyStringUtil.isNotBlank(renameFrom = annotation.renameFrom())) {
            return renameFrom;
        }
        return null;
    }

    protected Set<String> getColumnNames(EntityMigrationMetadata entityMigrationMetadata, boolean oldTable) {
        EntityMetadata entityMetadata = entityMigrationMetadata.getEntityMetadata();
        String columnTableName = EasyToSQLUtil.getSchemaTableName(this.sqlKeyword, entityMetadata, oldTable ? entityMetadata.getOldTableName() : entityMetadata.getTableName(), null, null);
        return EasyDatabaseUtil.getColumns(this.dataSource, "select * from " + columnTableName + " where 1=2");
    }

    @Override
    public List<MigrationCommand> syncTable(EntityMigrationMetadata entityMigrationMetadata, boolean oldTable) {
        Set<String> tableColumns = this.getColumnNames(entityMigrationMetadata, oldTable);
        ArrayList<MigrationCommand> migrationCommands = new ArrayList<MigrationCommand>();
        EntityMetadata entityMetadata = entityMigrationMetadata.getEntityMetadata();
        for (ColumnMetadata column : entityMetadata.getColumns()) {
            MigrationCommand migrationCommand;
            if (!this.columnExistInDb(entityMigrationMetadata, column) || tableColumns.contains(column.getName())) continue;
            String columnRenameFrom = this.getColumnRenameFrom(entityMigrationMetadata, column);
            if (EasyStringUtil.isNotBlank(columnRenameFrom) && tableColumns.contains(columnRenameFrom)) {
                migrationCommand = this.renameColumn(entityMigrationMetadata, columnRenameFrom, column);
                migrationCommands.add(migrationCommand);
                continue;
            }
            migrationCommand = this.addColumn(entityMigrationMetadata, column);
            migrationCommands.add(migrationCommand);
        }
        return migrationCommands;
    }

    protected abstract MigrationCommand renameColumn(EntityMigrationMetadata var1, String var2, ColumnMetadata var3);

    protected abstract MigrationCommand addColumn(EntityMigrationMetadata var1, ColumnMetadata var2);

    public String getQuoteSQLName(String val) {
        return EasyToSQLUtil.getQuoteSQLName(this.sqlKeyword, val);
    }

    public String getQuoteSQLName(String val1, String val2) {
        return EasyToSQLUtil.getQuoteSQLName(this.sqlKeyword, val1, val2);
    }
}

