/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.migration;

import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.EntityMetadataManager;
import com.easy.query.core.migration.DatabaseMigrationProvider;
import com.easy.query.core.migration.EntityMigrationMetadata;
import com.easy.query.core.migration.MigrationCommand;
import com.easy.query.core.migration.MigrationContext;
import com.easy.query.core.migration.MigrationsSQLGenerator;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyStringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DefaultMigrationsSQLGenerator
implements MigrationsSQLGenerator {
    private final EntityMetadataManager entityMetadataManager;
    private final DatabaseMigrationProvider databaseMigrationProvider;

    public DefaultMigrationsSQLGenerator(EntityMetadataManager entityMetadataManager, DatabaseMigrationProvider databaseMigrationProvider) {
        this.entityMetadataManager = entityMetadataManager;
        this.databaseMigrationProvider = databaseMigrationProvider;
    }

    @Override
    public List<MigrationCommand> generateMigrationSQL(MigrationContext migrationContext) {
        ArrayList<MigrationCommand> migrationCommands = new ArrayList<MigrationCommand>();
        for (Class<?> entity : migrationContext.getEntities()) {
            EntityMetadata entityMetadata = this.entityMetadataManager.getEntityMetadata(entity);
            EntityMigrationMetadata entityMigrationMetadata = this.databaseMigrationProvider.createEntityMigrationMetadata(entityMetadata);
            if (EasyStringUtil.isBlank(entityMetadata.getTableName())) {
                throw new EasyQueryInvalidOperationException(String.format("class type:[%s] not found [@Table] annotation.", EasyClassUtil.getSimpleName(entityMetadata.getEntityClass())));
            }
            boolean tableExists = this.databaseMigrationProvider.tableExists(entityMetadata.getSchemaOrNull(), entityMetadata.getTableName());
            if (!tableExists) {
                if (!Objects.equals(entityMetadata.getTableName(), entityMetadata.getOldTableName())) {
                    MigrationCommand migrationCommand;
                    boolean oldTableExists = this.databaseMigrationProvider.tableExists(entityMetadata.getSchemaOrNull(), entityMetadata.getOldTableName());
                    if (oldTableExists) {
                        List<MigrationCommand> columns;
                        migrationCommand = this.databaseMigrationProvider.renameTable(entityMigrationMetadata);
                        if (migrationCommand != null) {
                            migrationCommands.add(migrationCommand);
                        }
                        if ((columns = this.databaseMigrationProvider.syncTable(entityMigrationMetadata, true)) == null) continue;
                        migrationCommands.addAll(columns);
                        continue;
                    }
                    migrationCommand = this.databaseMigrationProvider.createTable(entityMigrationMetadata);
                    if (migrationCommand == null) continue;
                    migrationCommands.add(migrationCommand);
                    continue;
                }
                MigrationCommand migrationCommand = this.databaseMigrationProvider.createTable(entityMigrationMetadata);
                if (migrationCommand == null) continue;
                migrationCommands.add(migrationCommand);
                continue;
            }
            List<MigrationCommand> columns = this.databaseMigrationProvider.syncTable(entityMigrationMetadata, false);
            if (columns == null) continue;
            migrationCommands.addAll(columns);
        }
        return migrationCommands;
    }

    @Override
    public List<MigrationCommand> generateCreateTableMigrationSQL(MigrationContext migrationContext) {
        ArrayList<MigrationCommand> migrationCommands = new ArrayList<MigrationCommand>(migrationContext.getEntities().size());
        for (Class<?> entity : migrationContext.getEntities()) {
            EntityMetadata entityMetadata = this.entityMetadataManager.getEntityMetadata(entity);
            MigrationCommand migrationCommand = this.databaseMigrationProvider.createTable(new EntityMigrationMetadata(entityMetadata));
            if (migrationCommand == null) continue;
            migrationCommands.add(migrationCommand);
        }
        return migrationCommands;
    }

    @Override
    public List<MigrationCommand> generateDropTableMigrationSQL(MigrationContext migrationContext) {
        ArrayList<MigrationCommand> migrationCommands = new ArrayList<MigrationCommand>(migrationContext.getEntities().size());
        for (Class<?> entity : migrationContext.getEntities()) {
            EntityMetadata entityMetadata = this.entityMetadataManager.getEntityMetadata(entity);
            MigrationCommand migrationCommand = this.databaseMigrationProvider.dropTable(new EntityMigrationMetadata(entityMetadata));
            if (migrationCommand == null) continue;
            migrationCommands.add(migrationCommand);
        }
        return migrationCommands;
    }

    @Override
    public boolean tableExists(Class<?> entityType) {
        EntityMetadata entityMetadata = this.entityMetadataManager.getEntityMetadata(entityType);
        return this.databaseMigrationProvider.tableExists(entityMetadata.getSchemaOrNull(), entityMetadata.getTableName());
    }
}

