/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.api.initializer.mod;

import com.easy.query.core.configuration.EasyQueryOption;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.sharding.initializer.EntityShardingInitializer;
import com.easy.query.core.sharding.initializer.ShardingEntityBuilder;
import com.easy.query.core.util.EasyStringUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class AbstractShardingTableModInitializer<TEntity>
implements EntityShardingInitializer<TEntity> {
    protected abstract int mod();

    protected abstract int tailLength();

    protected char paddingWord() {
        return '0';
    }

    protected String tableSeparator() {
        return "_";
    }

    @Override
    public void configure(ShardingEntityBuilder<TEntity> builder) {
        EntityMetadata entityMetadata = builder.getEntityMetadata();
        String tableName = entityMetadata.getTableName();
        EasyQueryOption easyQueryOption = builder.getEasyQueryOption();
        List actualTableNames = IntStream.range(0, this.mod()).mapToObj(o -> {
            String tail = EasyStringUtil.leftPad(String.valueOf(o), this.tailLength(), this.paddingWord());
            return tableName + this.tableSeparator() + tail;
        }).collect(Collectors.toList());
        LinkedHashMap<String, Collection<String>> initTables = new LinkedHashMap<String, Collection<String>>();
        initTables.put(easyQueryOption.getDefaultDataSourceName(), actualTableNames);
        builder.actualTableNameInit(initTables);
        this.configure0(builder);
    }

    public void configure0(ShardingEntityBuilder<TEntity> builder) {
    }
}

