/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.api.initializer.time;

import com.easy.query.core.configuration.EasyQueryOption;
import com.easy.query.core.inject.ServiceProvider;
import com.easy.query.core.job.TimeJob;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.EntityMetadataManager;
import com.easy.query.core.sharding.initializer.EntityShardingInitializer;
import com.easy.query.core.sharding.initializer.ShardingEntityBuilder;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyDynamicUtil;
import com.easy.query.core.util.EasyMapUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;

public abstract class AbstractShardingTimeInitializer<T>
implements EntityShardingInitializer<T>,
TimeJob {
    protected final Class<?> entityClass;

    public AbstractShardingTimeInitializer() {
        Type superClass = this.getClass().getGenericSuperclass();
        if (superClass instanceof Class) {
            throw new IllegalArgumentException("Internal error: TypeReference constructed without actual type information");
        }
        this.entityClass = (Class)((ParameterizedType)superClass).getActualTypeArguments()[0];
    }

    protected abstract LocalDateTime getBeginTime();

    protected LocalDateTime getEndTime() {
        return LocalDateTime.now();
    }

    protected abstract LocalDateTime getBeginTimeToStart(LocalDateTime var1);

    protected abstract LocalDateTime getNextTime(LocalDateTime var1);

    protected String getTableSeparator() {
        return "_";
    }

    protected abstract String formatTail(LocalDateTime var1);

    protected String formatDataSource(LocalDateTime time, String defaultDataSource) {
        return defaultDataSource;
    }

    @Override
    public void configure(ShardingEntityBuilder<T> builder) {
        LocalDateTime endTime;
        EntityMetadata entityMetadata = builder.getEntityMetadata();
        EasyQueryOption easyQueryOption = builder.getEasyQueryOption();
        String defaultDataSourceName = easyQueryOption.getDefaultDataSourceName();
        String tableName = entityMetadata.getTableName();
        LocalDateTime setBeginTime = this.getBeginTime().plusMinutes(5L);
        LocalDateTime beginTime = this.getBeginTimeToStart(setBeginTime);
        if (beginTime.isAfter(endTime = this.getEndTime())) {
            throw new IllegalArgumentException("begin time:" + beginTime + " is after end time:" + endTime);
        }
        String tableSeparator = this.getTableSeparator();
        LinkedHashMap<String, Collection<String>> initTables = new LinkedHashMap<String, Collection<String>>();
        while (!beginTime.isAfter(endTime)) {
            String dataSource = this.formatDataSource(beginTime, defaultDataSourceName);
            String tail = this.formatTail(beginTime);
            Collection actualTableNames = EasyMapUtil.computeIfAbsent(initTables, dataSource, key -> new ArrayList());
            actualTableNames.add(tableName + tableSeparator + tail);
            beginTime = this.getNextTime(beginTime);
        }
        builder.actualTableNameInit(initTables);
        this.configure0(builder);
    }

    public abstract void configure0(ShardingEntityBuilder<T> var1);

    @Override
    public String jobName() {
        return EasyClassUtil.getSimpleName(this.getClass());
    }

    @Override
    public void execute(ServiceProvider serviceProvider) {
        EntityMetadataManager entityMetadataManager = serviceProvider.getService(EntityMetadataManager.class);
        EasyQueryOption easyQueryOption = serviceProvider.getService(EasyQueryOption.class);
        String defaultDataSourceName = easyQueryOption.getDefaultDataSourceName();
        EntityMetadata entityMetadata = entityMetadataManager.getEntityMetadata(this.entityClass);
        String tableName = entityMetadata.getTableName();
        LocalDateTime after5minutes = LocalDateTime.now().plusMinutes(5L);
        String dataSource = this.formatDataSource(after5minutes, defaultDataSourceName);
        String tail = this.formatTail(after5minutes);
        String actualTableName = tableName + this.getTableSeparator() + tail;
        EasyDynamicUtil.addShardingEntity(entityMetadataManager, this.entityClass, dataSource, actualTableName);
    }
}

