/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.api.route.mod;

import com.easy.query.core.enums.sharding.ShardingOperatorEnum;
import com.easy.query.core.expression.lambda.RouteFunction;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.metadata.ActualTable;
import com.easy.query.core.sharding.route.table.abstraction.AbstractTableRoute;
import com.easy.query.core.util.EasyStringUtil;

public abstract class AbstractModTableRoute<TEntity>
extends AbstractTableRoute<TEntity> {
    protected abstract int mod();

    protected abstract int tailLength();

    protected char paddingWord() {
        return '0';
    }

    @Override
    protected String tableSeparator() {
        return "_";
    }

    protected String formatShardingValue(Object shardingValue) {
        String value = String.valueOf(shardingValue);
        int tail = Math.abs(value.hashCode() % this.mod());
        return EasyStringUtil.leftPad(String.valueOf(tail), this.tailLength(), this.paddingWord());
    }

    @Override
    protected RouteFunction<ActualTable> getRouteFilter(TableAvailable table, Object shardingValue, ShardingOperatorEnum shardingOperator, boolean withEntity) {
        String tail = this.formatShardingValue(shardingValue);
        String tableName = table.getTableName() + this.tableSeparator() + tail;
        switch (shardingOperator) {
            case EQUAL: {
                return t -> tableName.compareToIgnoreCase(t.getActualTableName()) == 0;
            }
        }
        return t -> true;
    }
}

