/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.api.route.time;

import com.easy.query.core.sharding.api.route.time.AbstractTimeTableRoute;
import com.easy.query.core.util.EasyUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public abstract class AbstractWeekTableRoute<TEntity>
extends AbstractTimeTableRoute<TEntity> {
    @Override
    protected String formatShardingValue(LocalDateTime time) {
        LocalDateTime weekEnd = EasyUtil.getWeekEnd(time);
        String dd = weekEnd.format(DateTimeFormatter.ofPattern("dd"));
        return EasyUtil.getWeekStart(time).format(DateTimeFormatter.ofPattern("yyyyMMdd")) + "_" + dd;
    }

    @Override
    public boolean lessThanTimeStart(LocalDateTime shardingValue) {
        LocalDateTime timeWeekFirstDay = EasyUtil.getWeekStart(shardingValue);
        return shardingValue.isEqual(timeWeekFirstDay);
    }
}

