/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.context;

import com.easy.query.core.basic.jdbc.conn.ConnectionManager;
import com.easy.query.core.basic.jdbc.conn.EasyConnection;
import com.easy.query.core.basic.jdbc.executor.ExecutorContext;
import com.easy.query.core.basic.jdbc.executor.internal.common.ExecutionUnit;
import com.easy.query.core.basic.jdbc.executor.internal.merge.segment.PropertyGroup;
import com.easy.query.core.basic.jdbc.executor.internal.merge.segment.PropertyOrder;
import com.easy.query.core.configuration.EasyQueryOption;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.ExecuteMethodEnum;
import com.easy.query.core.enums.MergeBehaviorEnum;
import com.easy.query.core.enums.conn.ConnectionStrategyEnum;
import com.easy.query.core.enums.replica.ReplicaBehaviorEnum;
import com.easy.query.core.enums.sharding.ConnectionModeEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.executor.parser.ExecutionContext;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import com.easy.query.core.sharding.context.GroupMergeContext;
import com.easy.query.core.sharding.context.StreamMergeContext;
import com.easy.query.core.util.EasyMapUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EasyStreamMergeContext
implements StreamMergeContext {
    private static final Log log = LogFactory.getLog(EasyStreamMergeContext.class);
    protected final QueryRuntimeContext runtimeContext;
    protected final boolean isQuery;
    protected final Map<String, Collection<CloseableConnection>> closeableDataSourceConnections = new HashMap<String, Collection<CloseableConnection>>();
    protected final ExecutorContext executorContext;
    protected final ExecutionContext executionContext;
    protected final ConnectionManager connectionManager;
    protected final EasyQueryOption easyQueryOption;

    public EasyStreamMergeContext(ExecutorContext executorContext, ExecutionContext executionContext) {
        this.executorContext = executorContext;
        this.executionContext = executionContext;
        this.runtimeContext = executorContext.getRuntimeContext();
        this.connectionManager = this.runtimeContext.getConnectionManager();
        this.isQuery = executorContext.isQuery();
        this.easyQueryOption = this.runtimeContext.getQueryConfiguration().getEasyQueryOption();
    }

    @Override
    public ExecutorContext getExecutorContext() {
        return this.executorContext;
    }

    @Override
    public boolean hasBehavior(MergeBehaviorEnum mergeBehavior) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSharding() {
        return false;
    }

    @Override
    public boolean configReplica() {
        return false;
    }

    @Override
    public EasyQueryOption getEasyQueryOption() {
        return this.easyQueryOption;
    }

    @Override
    public ConnectionModeEnum getConnectionMode() {
        return ConnectionModeEnum.SYSTEM_AUTO;
    }

    @Override
    public void terminatedBreak() {
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public List<PropertyOrder> getOrders() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<PropertyGroup> getGroups() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ExecutionUnit> getExecutionUnits() {
        return this.executionContext.getExecutionUnits();
    }

    @Override
    public QueryRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public int getMaxShardingQueryLimit() {
        return 1;
    }

    @Override
    public boolean isQuery() {
        return this.isQuery;
    }

    @Override
    public boolean isSeqQuery() {
        return false;
    }

    @Override
    public boolean isReverseMerge() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<EasyConnection> getEasyConnections(String dataSourceName, int createDbConnectionCount) {
        Collection closeableConnections = EasyMapUtil.computeIfAbsent(this.closeableDataSourceConnections, dataSourceName, o -> new ArrayList());
        ConnectionStrategyEnum connectionStrategy = this.getConnectionStrategy(createDbConnectionCount);
        List<EasyConnection> easyConnections = this.connectionManager.getEasyConnections(createDbConnectionCount, dataSourceName, connectionStrategy);
        for (EasyConnection easyConnection : easyConnections) {
            closeableConnections.add(new CloseableConnection(connectionStrategy, this.connectionManager, easyConnection));
        }
        return easyConnections;
    }

    private ConnectionStrategyEnum getConnectionStrategy(int createDbConnectionCount) {
        ReplicaBehaviorEnum replicaBehavior;
        if (createDbConnectionCount <= 0) {
            throw new EasyQueryInvalidOperationException("cant get connection strategy");
        }
        if (!this.isSharding() || !this.isQuery()) {
            return ConnectionStrategyEnum.ShareConnection;
        }
        if (this.easyQueryOption.getReplicaOption() != null && (ReplicaBehaviorEnum.DefaultEnable.equals((Object)(replicaBehavior = this.easyQueryOption.getReplicaOption().getReplicaBehavior())) || ReplicaBehaviorEnum.OutTransactionEnable.equals((Object)replicaBehavior) && !this.connectionManager.currentThreadInTransaction())) {
            return ConnectionStrategyEnum.IndependentConnectionReplica;
        }
        if (createDbConnectionCount == 1 || !this.executionContext.isCrossTable() && !this.executionContext.isCrossDataSource()) {
            return ConnectionStrategyEnum.ShareConnection;
        }
        return ConnectionStrategyEnum.IndependentConnectionMaster;
    }

    @Override
    public boolean isPaginationQuery() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getOriginalOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getOriginalRows() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMergeOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMergeRows() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getRewriteOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getRewriteRows() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLBuilderSegment getSelectColumns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLBuilderSegment getGroupColumns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GroupMergeContext getGroupMergeContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExecuteMethodEnum getExecuteMethod() {
        return this.executorContext.getExecuteMethod();
    }

    @Override
    public void close() throws SQLException {
        for (Collection<CloseableConnection> value : this.closeableDataSourceConnections.values()) {
            for (CloseableConnection closeableConnection : value) {
                try {
                    closeableConnection.close();
                }
                catch (Exception ex) {
                    log.error("close stream merge context error.", ex);
                }
            }
        }
    }

    public static class CloseableConnection
    implements AutoCloseable {
        private final ConnectionStrategyEnum connectionStrategy;
        private final ConnectionManager easyConnectionManager;
        private final EasyConnection easyConnection;

        public CloseableConnection(ConnectionStrategyEnum connectionStrategy, ConnectionManager easyConnectionManager, EasyConnection easyConnection) {
            this.connectionStrategy = connectionStrategy;
            this.easyConnectionManager = easyConnectionManager;
            this.easyConnection = easyConnection;
        }

        @Override
        public void close() {
            if (ConnectionStrategyEnum.ShareConnection.equals((Object)this.connectionStrategy)) {
                this.easyConnectionManager.closeEasyConnection(this.easyConnection);
            } else {
                this.easyConnection.close();
            }
        }
    }
}

