/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.context;

import com.easy.query.core.basic.jdbc.executor.ExecutorContext;
import com.easy.query.core.basic.jdbc.executor.internal.merge.segment.PropertyGroup;
import com.easy.query.core.basic.jdbc.executor.internal.merge.segment.PropertyOrder;
import com.easy.query.core.enums.MergeBehaviorEnum;
import com.easy.query.core.enums.sharding.ConnectionModeEnum;
import com.easy.query.core.expression.executor.parser.EasyQueryPrepareParseResult;
import com.easy.query.core.expression.executor.parser.ExecutionContext;
import com.easy.query.core.expression.func.AggregationType;
import com.easy.query.core.expression.segment.FuncColumnSegment;
import com.easy.query.core.expression.segment.OrderBySegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.expression.segment.builder.SQLBuilderSegment;
import com.easy.query.core.expression.segment.impl.ColumnSegmentImpl;
import com.easy.query.core.expression.sql.expression.EntityQuerySQLExpression;
import com.easy.query.core.sharding.context.EntityStreamMergeContext;
import com.easy.query.core.sharding.context.GroupMergeContext;
import com.easy.query.core.util.EasyBitwiseUtil;
import com.easy.query.core.util.EasySQLSegmentUtil;
import com.easy.query.core.util.EasyShardingUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ShardingQueryEasyStreamMergeContext
extends EntityStreamMergeContext {
    protected static List<PropertyOrder> EMPTY_SQL_ORDERS = Collections.emptyList();
    protected static List<PropertyGroup> EMPTY_SQL_GROUPS = Collections.emptyList();
    private final EasyQueryPrepareParseResult easyQueryPrepareParseResult;
    protected final List<PropertyOrder> orders;
    protected final List<PropertyGroup> groups;
    protected final EntityQuerySQLExpression querySQLExpression;
    protected final GroupMergeContext groupMergeContext;
    protected volatile boolean terminated = false;

    public ShardingQueryEasyStreamMergeContext(ExecutorContext executorContext, ExecutionContext executionContext, EasyQueryPrepareParseResult easyQueryPrepareParseResult) {
        super(executorContext, executionContext, easyQueryPrepareParseResult);
        this.easyQueryPrepareParseResult = easyQueryPrepareParseResult;
        this.querySQLExpression = easyQueryPrepareParseResult.getEntityPredicateSQLExpression();
        this.orders = this.getOrders(this.querySQLExpression);
        this.groups = this.getGroups(this.querySQLExpression);
        this.groupMergeContext = new GroupMergeContext();
        this.initGroupMergeContext();
    }

    private void initGroupMergeContext() {
        SQLBuilderSegment projects = this.querySQLExpression.getProjects();
        List<SQLSegment> sqlSegments = projects.getSQLSegments();
        for (SQLSegment sqlSegment : sqlSegments) {
            FuncColumnSegment funcColumnSegment;
            AggregationType aggregationType;
            if (!(sqlSegment instanceof FuncColumnSegment) || !AggregationType.containsAvg(aggregationType = (funcColumnSegment = (FuncColumnSegment)sqlSegment).getAggregationType())) continue;
            this.groupMergeContext.addAvgColumn(funcColumnSegment);
        }
        if (this.groupMergeContext.hasAvgColumn()) {
            int columnIndex = 0;
            for (SQLSegment sqlSegment : sqlSegments) {
                FuncColumnSegment funcColumnSegment;
                AggregationType aggregationType;
                if (sqlSegment instanceof FuncColumnSegment && (Objects.equals((Object)AggregationType.SUM, (Object)(aggregationType = (funcColumnSegment = (FuncColumnSegment)sqlSegment).getAggregationType())) || Objects.equals((Object)AggregationType.COUNT, (Object)aggregationType))) {
                    this.groupMergeContext.addCountOrSum(funcColumnSegment, columnIndex);
                }
                ++columnIndex;
            }
        }
    }

    private List<PropertyOrder> getOrders(EntityQuerySQLExpression querySQLExpression) {
        if (this.isShardingMerge() && EasySQLSegmentUtil.isNotEmpty(querySQLExpression.getOrder())) {
            ArrayList<PropertyOrder> orders = new ArrayList<PropertyOrder>();
            SQLBuilderSegment projects = querySQLExpression.getProjects();
            for (SQLSegment sqlSegment : querySQLExpression.getOrder().getSQLSegments()) {
                if (!(sqlSegment instanceof OrderBySegment)) continue;
                OrderBySegment orderColumnSegment = (OrderBySegment)sqlSegment;
                PropertyOrder propertyOrder = EasyShardingUtil.findFirstPropertyOrderNotNull(projects.getSQLSegments(), orderColumnSegment, querySQLExpression);
                orders.add(propertyOrder);
            }
            return orders;
        }
        return EMPTY_SQL_ORDERS;
    }

    private List<PropertyGroup> getGroups(EntityQuerySQLExpression querySQLExpression) {
        if (EasySQLSegmentUtil.isNotEmpty(querySQLExpression.getGroup())) {
            ArrayList<PropertyGroup> groups = new ArrayList<PropertyGroup>();
            SQLBuilderSegment projects = querySQLExpression.getProjects();
            for (SQLSegment sqlSegment : querySQLExpression.getGroup().getSQLSegments()) {
                if (!(sqlSegment instanceof ColumnSegmentImpl)) continue;
                ColumnSegmentImpl columnSegment = (ColumnSegmentImpl)sqlSegment;
                PropertyGroup propertyGroup = EasyShardingUtil.findFirstPropertyGroupNotNull(projects.getSQLSegments(), columnSegment, querySQLExpression);
                groups.add(propertyGroup);
            }
            return groups;
        }
        return EMPTY_SQL_GROUPS;
    }

    @Override
    public boolean hasBehavior(MergeBehaviorEnum mergeBehavior) {
        return EasyBitwiseUtil.hasBit(this.executionContext.getMergeBehavior(), mergeBehavior.getCode());
    }

    @Override
    public List<PropertyOrder> getOrders() {
        return this.orders;
    }

    @Override
    public List<PropertyGroup> getGroups() {
        return this.groups;
    }

    @Override
    public boolean isPaginationQuery() {
        return this.easyQueryPrepareParseResult.getOriginalOffset() > 0L || this.easyQueryPrepareParseResult.getOriginalRows() > 0L;
    }

    @Override
    public long getOriginalOffset() {
        return this.easyQueryPrepareParseResult.getOriginalOffset();
    }

    @Override
    public long getOriginalRows() {
        return this.easyQueryPrepareParseResult.getOriginalRows();
    }

    @Override
    public long getMergeOffset() {
        if (this.isReverseMerge()) {
            return this.getRewriteRows() - this.getOriginalRows();
        }
        return this.getOriginalOffset();
    }

    @Override
    public long getMergeRows() {
        return this.getOriginalRows();
    }

    @Override
    public long getRewriteOffset() {
        return this.querySQLExpression.getOffset();
    }

    @Override
    public long getRewriteRows() {
        return this.querySQLExpression.getRows();
    }

    @Override
    public SQLBuilderSegment getSelectColumns() {
        return this.querySQLExpression.getProjects();
    }

    @Override
    public SQLBuilderSegment getGroupColumns() {
        return this.querySQLExpression.getGroup();
    }

    @Override
    public GroupMergeContext getGroupMergeContext() {
        return this.groupMergeContext;
    }

    @Override
    public boolean isSeqQuery() {
        return this.executionContext.isSequenceQuery() && this.easyQueryPrepareParseResult.getSequenceParseResult() != null;
    }

    @Override
    public boolean isReverseMerge() {
        return this.executionContext.isReverseMerge();
    }

    @Override
    public ConnectionModeEnum getConnectionMode() {
        return this.easyQueryPrepareParseResult.getConnectionMode();
    }

    @Override
    public int getMaxShardingQueryLimit() {
        return this.easyQueryPrepareParseResult.getMaxShardingQueryLimit();
    }

    @Override
    public void terminatedBreak() {
        this.terminated = true;
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }
}

