/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.initializer;

import com.easy.query.core.configuration.EasyQueryOption;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.sharding.initializer.ShardingInitOption;
import com.easy.query.core.sharding.initializer.ShardingInitOptionBuilder;
import com.easy.query.core.sharding.initializer.ShardingSequenceBuilder;
import com.easy.query.core.sharding.router.table.TableUnit;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;

public class ShardingEntityBuilder<T> {
    private final EntityMetadata entityMetadata;
    private final EasyQueryOption easyQueryOption;
    private final ShardingInitOptionBuilder shardingInitOptionBuilder;

    public ShardingEntityBuilder(EntityMetadata entityMetadata, EasyQueryOption easyQueryOption) {
        this.entityMetadata = entityMetadata;
        this.easyQueryOption = easyQueryOption;
        this.shardingInitOptionBuilder = new ShardingInitOptionBuilder();
    }

    public EasyQueryOption getEasyQueryOption() {
        return this.easyQueryOption;
    }

    public EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    public ShardingInitOption build() {
        return this.shardingInitOptionBuilder.build();
    }

    public ShardingEntityBuilder<T> actualTableNameInit(Map<String, Collection<String>> actualTableNames) {
        this.shardingInitOptionBuilder.setActualTableNames(actualTableNames);
        return this;
    }

    public ShardingSequenceBuilder<T> ascSequenceConfigure(Comparator<TableUnit> defaultTableNameComparator) {
        this.shardingInitOptionBuilder.setDefaultTableNameComparator(defaultTableNameComparator);
        return new ShardingSequenceBuilder(this, this.shardingInitOptionBuilder, this.entityMetadata);
    }

    public ShardingEntityBuilder<T> paginationReverse(double reverseFactor, long minReverseTotal) {
        if (reverseFactor <= 0.0) {
            throw new IllegalArgumentException("reverseFactor less than zero:" + reverseFactor);
        }
        if (minReverseTotal <= 1L) {
            throw new IllegalArgumentException("minReverseTotal less than one:" + minReverseTotal);
        }
        this.shardingInitOptionBuilder.setReverseFactor(reverseFactor);
        this.shardingInitOptionBuilder.setMinReverseTotal(minReverseTotal);
        return this;
    }

    public ShardingInitOptionBuilder getShardingInitOptionBuilder() {
        return this.shardingInitOptionBuilder;
    }
}

