/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.rewrite;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.sharding.rewrite.GroupAvgBehaviorEnum;
import java.util.Objects;

public class GroupRewriteStatus {
    public static int DEFAULT_GROUP_BEHAVIOR = GroupAvgBehaviorEnum.AVG.getCode() | GroupAvgBehaviorEnum.COUNT.getCode() | GroupAvgBehaviorEnum.SUM.getCode();
    private final TableAvailable table;
    private final String propertyName;
    public int behavior = DEFAULT_GROUP_BEHAVIOR;

    public GroupRewriteStatus(TableAvailable table, String propertyName) {
        this.table = table;
        this.propertyName = propertyName;
    }

    public TableAvailable getTable() {
        return this.table;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean hasBehavior(GroupAvgBehaviorEnum easyBehavior) {
        return (this.behavior & easyBehavior.getCode()) == easyBehavior.getCode();
    }

    public boolean addBehavior(GroupAvgBehaviorEnum easyBehavior) {
        if (this.hasBehavior(easyBehavior)) {
            return false;
        }
        this.behavior |= easyBehavior.getCode();
        return true;
    }

    public boolean removeBehavior(GroupAvgBehaviorEnum easyBehavior) {
        if (this.hasBehavior(easyBehavior)) {
            this.behavior &= ~easyBehavior.getCode();
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupRewriteStatus that = (GroupRewriteStatus)o;
        return Objects.equals(this.getTable(), that.getTable()) && Objects.equals(this.propertyName, that.propertyName);
    }

    public int hashCode() {
        return Objects.hash(this.table, this.propertyName);
    }
}

