/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.rewrite;

import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.expression.segment.OrderBySegment;
import com.easy.query.core.expression.segment.SQLSegment;
import com.easy.query.core.expression.segment.factory.SQLSegmentFactory;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.expression.sql.expression.EntityQuerySQLExpression;
import com.easy.query.core.expression.sql.expression.EntitySQLExpression;
import com.easy.query.core.sharding.rewrite.DefaultRewriteRouteUnit;
import com.easy.query.core.sharding.router.RouteUnit;
import java.util.List;

public class ReversePaginationRewriteRouteUnit
extends DefaultRewriteRouteUnit {
    private final long rewriteOffset;
    private final long rewriteRows;

    public ReversePaginationRewriteRouteUnit(long rewriteOffset, long rewriteRows, RouteUnit routeUnit) {
        super(routeUnit);
        this.rewriteOffset = rewriteOffset;
        this.rewriteRows = rewriteRows;
    }

    @Override
    public EntitySQLExpression rewrite(EntitySQLExpression entitySQLExpression) {
        EntityQuerySQLExpression querySQLExpression = (EntityQuerySQLExpression)super.rewrite(entitySQLExpression);
        querySQLExpression.setOffset(this.rewriteOffset);
        querySQLExpression.setRows(this.rewriteRows);
        List<SQLSegment> sqlSegments = querySQLExpression.getOrder().cloneSQLBuilder().getSQLSegments();
        querySQLExpression.getOrder().clear();
        QueryRuntimeContext runtimeContext = entitySQLExpression.getRuntimeContext();
        ExpressionContext expressionContext = entitySQLExpression.getExpressionMetadata().getExpressionContext();
        SQLSegmentFactory sqlSegmentFactory = runtimeContext.getSQLSegmentFactory();
        for (SQLSegment sqlSegment : sqlSegments) {
            if (!(sqlSegment instanceof OrderBySegment)) continue;
            OrderBySegment orderByColumnSegment = (OrderBySegment)sqlSegment;
            OrderBySegment reverseOrderByColumnSegment = sqlSegmentFactory.createOrderByColumnSegment(orderByColumnSegment.getTable(), orderByColumnSegment.getPropertyName(), expressionContext, !orderByColumnSegment.isAsc());
            querySQLExpression.getOrder().append(reverseOrderByColumnSegment);
        }
        return querySQLExpression;
    }
}

