/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.router;

import com.easy.query.core.basic.jdbc.parameter.ConstSQLParameter;
import com.easy.query.core.basic.jdbc.parameter.SQLParameter;
import com.easy.query.core.enums.SQLPredicateCompare;
import com.easy.query.core.enums.SQLPredicateCompareEnum;
import com.easy.query.core.enums.sharding.ShardingOperatorEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.expression.lambda.RouteFunction;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.condition.AndPredicateSegment;
import com.easy.query.core.expression.segment.condition.OrPredicateSegment;
import com.easy.query.core.expression.segment.condition.PredicateSegment;
import com.easy.query.core.expression.segment.condition.ShardingPredicateSegment;
import com.easy.query.core.expression.segment.condition.predicate.Predicate;
import com.easy.query.core.expression.segment.condition.predicate.ShardingPredicate;
import com.easy.query.core.expression.segment.condition.predicate.ValuePredicate;
import com.easy.query.core.expression.segment.condition.predicate.ValuesPredicate;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.sharding.route.RouteFilter;
import com.easy.query.core.sharding.router.RoutePredicateExpression;
import com.easy.query.core.sharding.router.descriptor.EntityRouteDescriptor;
import com.easy.query.core.sharding.router.descriptor.PredicateRouteDescriptor;
import com.easy.query.core.sharding.router.descriptor.RouteDescriptor;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyStringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class RoutePredicateDiscover<T> {
    private static final String GREATER_THAN = SQLPredicateCompareEnum.GT.getSQL();
    private static final String GREATER_THAN_OR_EQUAL = SQLPredicateCompareEnum.GE.getSQL();
    private static final String LESS_THAN = SQLPredicateCompareEnum.LT.getSQL();
    private static final String LESS_THAN_OR_EQUAL = SQLPredicateCompareEnum.LE.getSQL();
    private static final String EQUAL = SQLPredicateCompareEnum.EQ.getSQL();
    private static final String NOT_EQUAL = SQLPredicateCompareEnum.NE.getSQL();
    private static final String LIKE = SQLPredicateCompareEnum.LIKE.getSQL();
    private static final String NOT_IN = SQLPredicateCompareEnum.NOT_IN.getSQL();
    private static final String IN = SQLPredicateCompareEnum.IN.getSQL();
    private static final Map<String, ShardingOperatorEnum> operatorTranslate = new HashMap<String, ShardingOperatorEnum>();
    private final RouteDescriptor routeDescriptor;
    private final EntityMetadata entityMetadata;
    private final RouteFilter<T> routeFilter;
    private final Set<String> shardingProperties;
    private final String mainShardingProperty;

    private ShardingOperatorEnum translateOperator(SQLPredicateCompare operator, Object value) {
        String operatorText = operator.getSQL();
        ShardingOperatorEnum shardingOperatorEnum = operatorTranslate.get(operatorText);
        if (shardingOperatorEnum != null) {
            if (Objects.equals((Object)ShardingOperatorEnum.ALL_LIKE, (Object)shardingOperatorEnum) && value != null) {
                String valueStr = value.toString();
                if (!EasyStringUtil.startsWith(valueStr, "%")) {
                    return ShardingOperatorEnum.LIKE_MATCH_LEFT;
                }
                if (!EasyStringUtil.endsWith(valueStr, "%")) {
                    return ShardingOperatorEnum.LIKE_MATCH_RIGHT;
                }
            }
            return shardingOperatorEnum;
        }
        if (Objects.equals(IN, operatorText)) {
            return ShardingOperatorEnum.EQUAL;
        }
        if (Objects.equals(NOT_IN, operatorText)) {
            return ShardingOperatorEnum.NOT_EQUAL;
        }
        return ShardingOperatorEnum.UN_KNOWN;
    }

    public RoutePredicateDiscover(RouteDescriptor routeDescriptor, RouteFilter<T> routeFilter, boolean shardingTableRoute) {
        this.routeDescriptor = routeDescriptor;
        this.entityMetadata = routeDescriptor.getTable().getEntityMetadata();
        this.routeFilter = routeFilter;
        if (shardingTableRoute) {
            this.shardingProperties = this.entityMetadata.getShardingTablePropertyNames();
            this.mainShardingProperty = this.entityMetadata.getShardingTablePropertyName();
        } else {
            this.shardingProperties = this.entityMetadata.getShardingDataSourcePropertyNames();
            this.mainShardingProperty = this.entityMetadata.getShardingDataSourcePropertyName();
        }
    }

    public RoutePredicateExpression<T> getRouteParseExpression() {
        if (this.routeDescriptor instanceof PredicateRouteDescriptor) {
            return this.getPredicateSQLRouteParseExpression((PredicateRouteDescriptor)this.routeDescriptor);
        }
        if (this.routeDescriptor instanceof EntityRouteDescriptor) {
            Object entity = ((EntityRouteDescriptor)this.routeDescriptor).getEntity();
            if (entity == null) {
                throw new EasyQueryInvalidOperationException("route parse not support null entity.");
            }
            return this.getEntitySQLRouteParseExpression(entity);
        }
        throw new UnsupportedOperationException(EasyClassUtil.getInstanceSimpleName(this.routeDescriptor));
    }

    private RoutePredicateExpression<T> getPredicateSQLRouteParseExpression(PredicateRouteDescriptor predicateRouteDescriptor) {
        List<PredicateSegment> predicates = predicateRouteDescriptor.getPredicates();
        if (EasyCollectionUtil.isEmpty(predicates)) {
            return RoutePredicateExpression.getDefault();
        }
        if (EasyCollectionUtil.isSingle(predicates)) {
            PredicateSegment predicate = EasyCollectionUtil.first(predicates);
            if (predicate instanceof ShardingPredicateSegment) {
                return this.parsePredicate((ShardingPredicateSegment)((Object)predicate));
            }
            return RoutePredicateExpression.getDefault();
        }
        RoutePredicateExpression defaultRoutePredicate = RoutePredicateExpression.getDefault();
        for (PredicateSegment predicate : predicates) {
            if (!(predicate instanceof ShardingPredicateSegment)) continue;
            RoutePredicateExpression<T> parseRoutePredicate = this.parsePredicate((ShardingPredicateSegment)((Object)predicate));
            defaultRoutePredicate = defaultRoutePredicate.and(parseRoutePredicate);
        }
        return defaultRoutePredicate;
    }

    private RoutePredicateExpression<T> parsePredicate(ShardingPredicateSegment where) {
        if (where.isPredicate()) {
            Predicate predicate = where.getPredicate();
            if (predicate instanceof ShardingPredicate) {
                if (predicate instanceof ValuePredicate) {
                    return this.parseValuePredicate((ValuePredicate)predicate);
                }
                if (predicate instanceof ValuesPredicate) {
                    return this.parseValuesPredicate((ValuesPredicate)predicate);
                }
            }
        } else if (EasyCollectionUtil.isNotEmpty(where.getChildren())) {
            RoutePredicateExpression routePredicate = RoutePredicateExpression.getDefault();
            for (PredicateSegment child : where.getChildren()) {
                if (child instanceof AndPredicateSegment) {
                    routePredicate = routePredicate.and(this.parsePredicate((AndPredicateSegment)child));
                    continue;
                }
                if (!(child instanceof OrPredicateSegment)) continue;
                routePredicate = routePredicate.or(this.parsePredicate((OrPredicateSegment)child));
            }
            return routePredicate;
        }
        return RoutePredicateExpression.getDefault();
    }

    private RoutePredicateExpression<T> parseValuePredicate(ValuePredicate valuePredicate) {
        SQLParameter parameter;
        TableAvailable table = valuePredicate.getTable();
        String propertyName = valuePredicate.getPropertyName();
        if (Objects.equals(table, this.routeDescriptor.getTable()) && this.shardingProperties.contains(propertyName) && (parameter = valuePredicate.getParameter()) instanceof ConstSQLParameter) {
            ConstSQLParameter constSQLParameter = (ConstSQLParameter)parameter;
            Object value = constSQLParameter.getValue();
            SQLPredicateCompare operator = valuePredicate.getOperator();
            ShardingOperatorEnum shardingOperator = this.translateOperator(operator, value);
            RouteFunction<T> routePredicate = this.routeFilter.routeFilter(table, value, shardingOperator, propertyName, Objects.equals(this.mainShardingProperty, propertyName), false);
            return new RoutePredicateExpression(routePredicate);
        }
        return RoutePredicateExpression.getDefault();
    }

    private RoutePredicateExpression<T> parseValuesPredicate(ValuesPredicate valuesPredicate) {
        TableAvailable table = valuesPredicate.getTable();
        String propertyName = valuesPredicate.getPropertyName();
        if (Objects.equals(table, this.routeDescriptor.getTable()) && this.shardingProperties.contains(propertyName)) {
            SQLPredicateCompare operator = valuesPredicate.getOperator();
            ShardingOperatorEnum shardingOperator = this.translateOperator(operator, null);
            boolean in = Objects.equals((Object)ShardingOperatorEnum.EQUAL, (Object)shardingOperator);
            RoutePredicateExpression containsRoutePredicate = in ? RoutePredicateExpression.getDefaultFalse() : RoutePredicateExpression.getDefault();
            Collection<SQLParameter> parameters = valuesPredicate.getParameters();
            for (SQLParameter parameter : parameters) {
                ConstSQLParameter constSQLParameter = (ConstSQLParameter)parameter;
                Object value = constSQLParameter.getValue();
                RouteFunction<T> routePredicate = this.routeFilter.routeFilter(table, value, shardingOperator, propertyName, Objects.equals(this.mainShardingProperty, propertyName), false);
                if (in) {
                    containsRoutePredicate.or(new RoutePredicateExpression(routePredicate));
                    continue;
                }
                containsRoutePredicate.and(new RoutePredicateExpression(routePredicate));
            }
        }
        return RoutePredicateExpression.getDefault();
    }

    private RoutePredicateExpression<T> getEntitySQLRouteParseExpression(Object entity) {
        ColumnMetadata columnMetadata = this.entityMetadata.getColumnNotNull(this.mainShardingProperty);
        Property<Object, ?> shardingKeyPropertyGetter = columnMetadata.getGetterCaller();
        Object shardingValue = shardingKeyPropertyGetter.apply(entity);
        RouteFunction<T> routePredicate = this.routeFilter.routeFilter(this.routeDescriptor.getTable(), shardingValue, ShardingOperatorEnum.EQUAL, this.mainShardingProperty, true, true);
        return new RoutePredicateExpression(routePredicate);
    }

    static {
        operatorTranslate.put(GREATER_THAN, ShardingOperatorEnum.GREATER_THAN);
        operatorTranslate.put(GREATER_THAN_OR_EQUAL, ShardingOperatorEnum.GREATER_THAN_OR_EQUAL);
        operatorTranslate.put(LESS_THAN, ShardingOperatorEnum.LESS_THAN);
        operatorTranslate.put(LESS_THAN_OR_EQUAL, ShardingOperatorEnum.LESS_THAN_OR_EQUAL);
        operatorTranslate.put(EQUAL, ShardingOperatorEnum.EQUAL);
        operatorTranslate.put(NOT_EQUAL, ShardingOperatorEnum.NOT_EQUAL);
        operatorTranslate.put(LIKE, ShardingOperatorEnum.ALL_LIKE);
    }
}

