/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.router;

import com.easy.query.core.expression.lambda.RouteFunction;

public class RoutePredicateExpression<T> {
    private static final RouteFunction<?> DEFAULT_TRUE_ROUTE_PREDICATE = v -> true;
    private static final RouteFunction<?> DEFAULT_FALSE_ROUTE_PREDICATE = v -> false;
    private final RouteFunction<T> routePredicate;

    public static <TSource> RoutePredicateExpression<TSource> getDefault() {
        return new RoutePredicateExpression();
    }

    public static <TSource> RoutePredicateExpression<TSource> getDefaultFalse() {
        return new RoutePredicateExpression(DEFAULT_FALSE_ROUTE_PREDICATE);
    }

    public RoutePredicateExpression() {
        this(DEFAULT_TRUE_ROUTE_PREDICATE);
    }

    public RoutePredicateExpression(RouteFunction routePredicate) {
        this.routePredicate = routePredicate;
    }

    public RouteFunction<T> getRoutePredicate() {
        return this.routePredicate;
    }

    public RoutePredicateExpression<T> and(RoutePredicateExpression<T> routePredicateExpression) {
        RouteFunction<T> routePredicate = routePredicateExpression.getRoutePredicate();
        RouteFunction<Object> func = v -> this.routePredicate.apply(v) && routePredicate.apply(v);
        return new RoutePredicateExpression<T>(func);
    }

    public RoutePredicateExpression<T> or(RoutePredicateExpression<T> routePredicateExpression) {
        RouteFunction<T> routePredicate = routePredicateExpression.getRoutePredicate();
        RouteFunction<Object> func = v -> this.routePredicate.apply(v) || routePredicate.apply(v);
        return new RoutePredicateExpression<T>(func);
    }
}

