/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.sharding.router.manager.impl;

import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.sharding.route.table.TableRoute;
import com.easy.query.core.sharding.router.datasource.engine.DataSourceRouteResult;
import com.easy.query.core.sharding.router.descriptor.RouteDescriptor;
import com.easy.query.core.sharding.router.manager.TableRouteManager;
import com.easy.query.core.sharding.router.table.TableRouteUnit;
import com.easy.query.core.sharding.router.table.TableRouter;
import com.easy.query.core.util.EasyClassUtil;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultTableRouteManager
implements TableRouteManager {
    private final Map<Class<?>, TableRoute<?>> entityRouteCache = new ConcurrentHashMap();
    private final TableRouter tableRouter;

    public DefaultTableRouteManager(TableRouter tableRouter) {
        this.tableRouter = tableRouter;
    }

    @Override
    public Collection<TableRouteUnit> routeTo(DataSourceRouteResult dataSourceRouteResult, RouteDescriptor routeDescriptor) {
        TableRoute<?> route = this.getRoute(routeDescriptor.getTable().getEntityClass());
        return this.tableRouter.route(route, dataSourceRouteResult, routeDescriptor);
    }

    @Override
    public TableRoute<?> getRoute(Class<?> entityClass) {
        TableRoute<?> tableRoute = this.entityRouteCache.get(entityClass);
        if (tableRoute == null) {
            throw new EasyQueryInvalidOperationException(EasyClassUtil.getSimpleName(entityClass) + " not found table route");
        }
        return tableRoute;
    }

    @Override
    public boolean addRoute(TableRoute<?> tableRoute) {
        TableRoute<?> oldTableRoute = this.entityRouteCache.get(tableRoute.entityClass());
        if (oldTableRoute == null) {
            this.entityRouteCache.put(tableRoute.entityClass(), tableRoute);
            return true;
        }
        return false;
    }
}

