/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.util;

import java.util.UUID;

public class EasyCompareUtil {
    private EasyCompareUtil() {
    }

    public static int safeCompare(Comparable x, Comparable y, boolean asc, boolean caseSensitive) {
        if (asc) {
            return EasyCompareUtil.doSafeCompare(x, y, caseSensitive);
        }
        return EasyCompareUtil.doSafeCompare(y, x, caseSensitive);
    }

    private static int doSafeCompare(Comparable x, Comparable y, boolean caseSensitive) {
        if (x == null && y == null) {
            return 0;
        }
        if (x == null) {
            return -1;
        }
        if (y == null) {
            return 1;
        }
        if (x instanceof UUID && y instanceof UUID) {
            return EasyCompareUtil.compareUUID0((UUID)x, (UUID)y);
        }
        if (!caseSensitive && x instanceof String && y instanceof String) {
            return EasyCompareUtil.compareToIgnoreCaseString((String)((Object)x), (String)((Object)y));
        }
        return x.compareTo(y);
    }

    private static int compareToIgnoreCaseString(String x, String y) {
        return x.toUpperCase().compareTo(y.toUpperCase());
    }

    private static int compareUUID0(UUID x, UUID y) {
        byte[] b1 = EasyCompareUtil.toByteArray(x);
        byte[] b2 = EasyCompareUtil.toByteArray(y);
        for (int i = 0; i < 16; ++i) {
            int cmp = Byte.compare(b1[i], b2[i]);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private static byte[] toByteArray(UUID uuid) {
        byte[] byteArray = new byte[16];
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        for (int i = 0; i < 8; ++i) {
            byteArray[i] = (byte)(msb >>> 8 * (7 - i));
            byteArray[8 + i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return byteArray;
    }
}

