/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.util;

import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.exception.EasyQuerySQLCommandException;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;

public class EasyDatabaseUtil {
    private static final Log log = LogFactory.getLog(EasyDatabaseUtil.class);

    public static String getJdbcUrl(DataSource dataSource) {
        try {
            Method getUrlMethod = dataSource.getClass().getMethod("getJdbcUrl", new Class[0]);
            return (String)getUrlMethod.invoke((Object)dataSource, new Object[0]);
        }
        catch (Exception e) {
            try {
                Method getUrlMethod = dataSource.getClass().getMethod("getUrl", new Class[0]);
                return (String)getUrlMethod.invoke((Object)dataSource, new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6 JDBC URL", ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDatabaseName(DataSource dataSource, Supplier<String> def) {
        try (Connection connection = dataSource.getConnection();){
            String string = connection.getCatalog();
            return string;
        }
        catch (Exception exception) {
            if (def != null) return def.get();
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public static Set<String> getColumns(DataSource dataSource, String sql) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static List<Map<String, Object>> sqlQuery(DataSource dataSource, String sql, List<Object> parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void checkAndCreateDatabase(DataSource dataSource, Function<String, String> checkDbSqlFunc, Function<String, String> createDbSqlFunc) {
        block39: {
            String jdbcUrl = EasyDatabaseUtil.getJdbcUrlByReflection(dataSource);
            String username = EasyDatabaseUtil.getDataSourceProperty(dataSource, "getUsername");
            String password = EasyDatabaseUtil.getDataSourceProperty(dataSource, "getPassword");
            String dbName = EasyDatabaseUtil.parseDatabaseName(jdbcUrl);
            String serverUrl = EasyDatabaseUtil.getServerBaseUrl(jdbcUrl);
            try (Connection serverConn = DriverManager.getConnection(serverUrl, username, password);){
                boolean databaseExist = false;
                try (Statement stmt = serverConn.createStatement();){
                    String checkDbSQL = checkDbSqlFunc.apply(dbName);
                    log.info("check db sql:" + checkDbSQL);
                    ResultSet resultSet = stmt.executeQuery(checkDbSQL);
                    databaseExist = resultSet.next();
                }
                if (databaseExist) break block39;
                stmt = serverConn.createStatement();
                var12_15 = null;
                try {
                    String createDbSQL = createDbSqlFunc.apply(dbName);
                    log.info("create db sql:" + createDbSQL);
                    stmt.execute(createDbSQL);
                }
                catch (Throwable throwable) {
                    var12_15 = throwable;
                    throw throwable;
                }
                finally {
                    if (stmt != null) {
                        if (var12_15 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable) {
                                var12_15.addSuppressed(throwable);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                throw new EasyQuerySQLCommandException(e);
            }
        }
    }

    public static String getJdbcUrlByReflection(DataSource dataSource) {
        try {
            Method getUrlMethod = dataSource.getClass().getMethod("getJdbcUrl", new Class[0]);
            return (String)getUrlMethod.invoke((Object)dataSource, new Object[0]);
        }
        catch (Exception e1) {
            try {
                Method getUrlMethod = dataSource.getClass().getMethod("getUrl", new Class[0]);
                return (String)getUrlMethod.invoke((Object)dataSource, new Object[0]);
            }
            catch (Exception e2) {
                throw new EasyQuerySQLCommandException("\u65e0\u6cd5\u83b7\u53d6 JDBC URL", e2);
            }
        }
    }

    private static String getDataSourceProperty(DataSource dataSource, String methodName) {
        try {
            Method method = dataSource.getClass().getMethod(methodName, new Class[0]);
            return (String)method.invoke((Object)dataSource, new Object[0]);
        }
        catch (Exception e) {
            throw new EasyQueryInvalidOperationException("cant get datasource property: " + methodName, e);
        }
    }

    public static String parseDatabaseName(String jdbcUrl) {
        Pattern genericPattern = Pattern.compile("jdbc:[^:]+://[^/]+/([^/?]+)");
        Matcher genericMatcher = genericPattern.matcher(jdbcUrl);
        if (genericMatcher.find()) {
            return genericMatcher.group(1);
        }
        Pattern sqlServerPattern = Pattern.compile(";databaseName=([^;]+)", 2);
        Matcher sqlServerMatcher = sqlServerPattern.matcher(jdbcUrl);
        if (sqlServerMatcher.find()) {
            return sqlServerMatcher.group(1);
        }
        Pattern oraclePattern = Pattern.compile("jdbc:oracle:thin:@[^:]+:[^:]+:(\\w+)");
        Matcher oracleMatcher = oraclePattern.matcher(jdbcUrl);
        if (oracleMatcher.find()) {
            return oracleMatcher.group(1);
        }
        throw new IllegalArgumentException("cant parse database name: " + jdbcUrl);
    }

    public static String getServerBaseUrl(String jdbcUrl) {
        String serverBaseUrl0 = EasyDatabaseUtil.getServerBaseUrl0(jdbcUrl);
        if (jdbcUrl.contains("?")) {
            return serverBaseUrl0 + "?" + jdbcUrl.split("\\?")[1];
        }
        return serverBaseUrl0;
    }

    public static String getServerBaseUrl0(String jdbcUrl) {
        if (jdbcUrl.contains("jdbc:sqlserver:")) {
            return jdbcUrl.replaceAll("(?i);databaseName=[^;]+", "");
        }
        return jdbcUrl.replaceFirst("/[^/?]+([?].*)?$", "/");
    }
}

