/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.util;

import com.easy.query.core.configuration.ShardingDataSource;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.EntityMetadataManager;
import com.easy.query.core.sharding.EasyQueryDataSource;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyStringUtil;
import javax.sql.DataSource;

public final class EasyDynamicUtil {
    private EasyDynamicUtil() {
    }

    public static void addDataSource(QueryRuntimeContext runtimeContext, ShardingDataSource shardingDataSource) {
        String dataSourceName = shardingDataSource.getDataSourceName();
        DataSource dataSource = shardingDataSource.getDataSource();
        int dataSourcePoolSize = shardingDataSource.getDataSourceMergePoolSize();
        EasyQueryDataSource easyQueryDataSource = runtimeContext.getEasyQueryDataSource();
        easyQueryDataSource.addDataSource(dataSourceName, dataSource, dataSourcePoolSize);
    }

    public static void addShardingEntity(QueryRuntimeContext runtimeContext, Class<?> entityClass, String dataSourceName, String actualTableName) {
        EntityMetadataManager entityMetadataManager = runtimeContext.getEntityMetadataManager();
        EasyDynamicUtil.addShardingEntity(entityMetadataManager, entityClass, dataSourceName, actualTableName);
    }

    public static void addShardingEntity(EntityMetadataManager entityMetadataManager, Class<?> entityClass, String dataSourceName, String actualTableName) {
        EntityMetadata entityMetadata = entityMetadataManager.getEntityMetadata(entityClass);
        if (EasyStringUtil.isBlank(entityMetadata.getTableName())) {
            throw new EasyQueryInvalidOperationException(EasyClassUtil.getSimpleName(entityClass) + " is not table entity");
        }
        if (!entityMetadata.isSharding()) {
            throw new EasyQueryInvalidOperationException(EasyClassUtil.getSimpleName(entityClass) + " is not sharding entity");
        }
        entityMetadata.addActualTableWithDataSource(dataSourceName, actualTableName);
    }
}

