/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.util;

import com.easy.query.core.exception.EasyQueryInvalidFieldCheckException;
import com.easy.query.core.util.EasyStringUtil;

public class EasyFieldCheckUtil {
    private static final char[] UN_SAFE_CHARS = "'`\"<>&+=#-;".toCharArray();

    private static boolean isUnSafeChar(char ch) {
        for (char c : UN_SAFE_CHARS) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    public static String toCheckField(String column) {
        if (EasyStringUtil.isBlank(column)) {
            throw new EasyQueryInvalidFieldCheckException("column name must not be empty");
        }
        int strLen = column.length();
        for (int i = 0; i < strLen; ++i) {
            char ch = column.charAt(i);
            if (Character.isWhitespace(ch)) {
                throw new EasyQueryInvalidFieldCheckException("column name must not has space char.");
            }
            if (!EasyFieldCheckUtil.isUnSafeChar(ch)) continue;
            throw new EasyQueryInvalidFieldCheckException("column name has unsafe char: [" + ch + "].");
        }
        return column;
    }
}

