/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.util;

import com.easy.query.core.exception.EasyQueryException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class EasyObjectUtil {
    private EasyObjectUtil() {
    }

    public static <T, TR> TR getValueOrNull(T source, Function<T, TR> getter) {
        return EasyObjectUtil.getValueOrDefault(source, getter, null);
    }

    public static <T, TR> TR getValueOrDefault(T source, Function<T, TR> getter, TR def) {
        if (Objects.isNull(source)) {
            return def;
        }
        return getter.apply(source);
    }

    public static <T, N> N typeCast(T original) {
        try {
            return (N)original;
        }
        catch (Exception e) {
            throw new EasyQueryException(e.getMessage(), e);
        }
    }

    public static <T, N> N typeCastNullable(T original) {
        if (original == null) {
            return null;
        }
        return EasyObjectUtil.typeCast(original);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Optional) {
            return !((Optional)obj).isPresent();
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        return obj instanceof Map && ((Map)obj).isEmpty();
    }
}

