/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Consumer;

public class EasyStaticMethodUtil {
    public static Object invokeStaticMethod(Class<?> clazz, String methodName, String[] parameterTypes, Object[] args, Consumer<Exception> exceptionConsumer) {
        try {
            Class[] paramClasses = new Class[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                paramClasses[i] = EasyStaticMethodUtil.parseType(parameterTypes[i]);
            }
            Method method = clazz.getDeclaredMethod(methodName, paramClasses);
            method.setAccessible(true);
            return method.invoke(null, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            exceptionConsumer.accept(ex);
            return null;
        }
    }

    private static Class<?> parseType(String typeStr) throws ClassNotFoundException {
        switch (typeStr) {
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        if (typeStr.endsWith("[]")) {
            String elementType = typeStr.substring(0, typeStr.length() - 2);
            return Class.forName("[L" + elementType + ";");
        }
        return Class.forName(typeStr);
    }

    public static void main(String[] args) throws Exception {
        Object result = EasyStaticMethodUtil.invokeStaticMethod(Integer.class, "parseInt", new String[]{"java.lang.String"}, new Object[]{"123"}, c -> {});
        System.out.println(result);
        Object list = EasyStaticMethodUtil.invokeStaticMethod(Arrays.class, "asList", new String[]{"java.lang.Object[]"}, new Object[]{new String[]{"A", "B"}}, c -> {});
        System.out.println(list);
    }
}

