/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.util;

import com.easy.query.core.basic.extension.track.EntityState;
import com.easy.query.core.basic.extension.track.EntityTrackProperty;
import com.easy.query.core.basic.extension.track.TrackDiffEntry;
import com.easy.query.core.basic.extension.track.TrackManager;
import com.easy.query.core.basic.jdbc.executor.ExecutorContext;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.exception.EasyQueryTrackInvalidOperationException;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.expression.lambda.TrackKeyFunc;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.EntityMetadataManager;
import com.easy.query.core.util.EasyBeanUtil;
import com.easy.query.core.util.EasyMapUtil;
import com.easy.query.core.util.EasyObjectUtil;
import com.easy.query.core.util.EasyStringUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class EasyTrackUtil {
    private static final ConcurrentHashMap<Class<?>, TrackKeyFunc<Object>> trackKeyFuncMap = new ConcurrentHashMap();

    public static String getTrackKey(EntityMetadata entityMetadata, Object entity) {
        TrackKeyFunc entityTrackKeyFunc = EasyMapUtil.computeIfAbsent(trackKeyFuncMap, entity.getClass(), k -> {
            Property<Object, ?> lambdaProperty;
            ColumnMetadata columnMetadata;
            String propertyName;
            boolean multiTableMapping;
            Collection<String> keyProperties = entityMetadata.getKeyProperties();
            int shardingCapacity = 0;
            boolean multiDataSourceMapping = entityMetadata.isMultiDataSourceMapping();
            if (multiDataSourceMapping) {
                ++shardingCapacity;
            }
            if (multiTableMapping = entityMetadata.isMultiTableMapping()) {
                ++shardingCapacity;
            }
            LinkedHashMap propertiesMap = new LinkedHashMap(keyProperties.size() + shardingCapacity);
            for (String keyProperty : keyProperties) {
                ColumnMetadata columnMetadata2 = entityMetadata.getColumnNotNull(keyProperty);
                Property<Object, ?> lambdaProperty2 = columnMetadata2.getGetterCaller();
                propertiesMap.put(keyProperty, lambdaProperty2);
            }
            if (multiDataSourceMapping) {
                propertyName = entityMetadata.getShardingDataSourcePropertyName();
                columnMetadata = entityMetadata.getColumnNotNull(propertyName);
                lambdaProperty = columnMetadata.getGetterCaller();
                propertiesMap.put(propertyName, lambdaProperty);
            }
            if (multiTableMapping) {
                propertyName = entityMetadata.getShardingTablePropertyName();
                columnMetadata = entityMetadata.getColumnNotNull(propertyName);
                lambdaProperty = columnMetadata.getGetterCaller();
                propertiesMap.put(propertyName, lambdaProperty);
            }
            return o -> {
                if (propertiesMap.isEmpty()) {
                    return null;
                }
                StringBuilder trackKey = new StringBuilder();
                Iterator iterator = propertiesMap.entrySet().iterator();
                Map.Entry<String, Property<Object, ?>> firstProperty = iterator.next();
                String firstTrackValue = EasyTrackUtil.getAndCheckTrackValue(o, firstProperty);
                trackKey.append(firstTrackValue);
                while (iterator.hasNext()) {
                    Map.Entry<String, Property<Object, ?>> property = iterator.next();
                    String trackValue = EasyTrackUtil.getAndCheckTrackValue(o, property);
                    trackKey.append(",").append(trackValue);
                }
                return trackKey.toString();
            };
        });
        return entityTrackKeyFunc.get(entity);
    }

    private static String getAndCheckTrackValue(Object entity, Map.Entry<String, Property<Object, ?>> property) {
        String propertyName = property.getKey();
        Object propertyValue = property.getValue().apply(entity);
        if (Objects.isNull(propertyValue)) {
            throw new EasyQueryTrackInvalidOperationException("track key cant null :" + propertyName);
        }
        return propertyName + ":" + propertyValue;
    }

    public static EntityTrackProperty getTrackDiffProperty(EntityMetadataManager entityMetadataManager, EntityState entityState) {
        Class<?> entityClass = entityState.getEntityClass();
        EntityMetadata entityMetadata = entityMetadataManager.getEntityMetadata(entityClass);
        EntityTrackProperty entityTrackProperty = new EntityTrackProperty();
        Collection<String> properties = entityMetadata.getProperties();
        for (String propertyName : properties) {
            Object currentPropertyValue;
            ColumnMetadata columnMetadata = entityMetadata.getColumnNotNull(propertyName);
            if (columnMetadata.isPrimary() || columnMetadata.isValueObject()) continue;
            Object originalPropertyValue = EasyBeanUtil.getPropertyValue(entityState.getOriginalValue(), entityMetadata, columnMetadata);
            if (EasyTrackUtil.propertyValueEquals(columnMetadata, originalPropertyValue, currentPropertyValue = EasyBeanUtil.getPropertyValue(entityState.getCurrentValue(), entityMetadata, columnMetadata))) {
                entityTrackProperty.getSameProperties().add(propertyName);
                continue;
            }
            entityTrackProperty.getDiffProperties().put(propertyName, new TrackDiffEntry(originalPropertyValue, currentPropertyValue));
        }
        return entityTrackProperty;
    }

    private static boolean propertyValueEquals(ColumnMetadata columnMetadata, Object original, Object current) {
        if (original == null && current == null) {
            return true;
        }
        if (original == null) {
            return false;
        }
        if (current == null) {
            return false;
        }
        if (Comparable.class.isAssignableFrom(columnMetadata.getPropertyType())) {
            return ((Comparable)original).compareTo(EasyObjectUtil.typeCastNullable(current)) == 0;
        }
        return Objects.equals(original, current);
    }

    public static boolean trackBean(ExecutorContext context, Class<?> clazz) {
        if (context.isTracking()) {
            QueryRuntimeContext runtimeContext = context.getRuntimeContext();
            TrackManager trackManager = runtimeContext.getTrackManager();
            if (!trackManager.currentThreadTracking()) {
                return false;
            }
            EntityMetadata entityMetadata = runtimeContext.getEntityMetadataManager().getEntityMetadata(clazz);
            return !EasyStringUtil.isBlank(entityMetadata.getTableName());
        }
        return false;
    }
}

