/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.util;

import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.expression.sql.include.EasyTreeNode;
import com.easy.query.core.expression.sql.include.RelationValue;
import com.easy.query.core.expression.sql.include.multi.RelationValueColumnMetadata;
import com.easy.query.core.expression.sql.include.multi.RelationValueFactory;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.NavigateMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class EasyTreeUtil {
    public static <T> List<T> generateTrees(List<T> nodes, EntityMetadata entityMetadata, NavigateMetadata navigateMetadata, QueryRuntimeContext runtimeContext) {
        RelationValueFactory relationValueFactory = runtimeContext.getRelationValueFactory();
        RelationValueColumnMetadata selfRelationValueColumnMetadata = relationValueFactory.create(entityMetadata, navigateMetadata.getSelfPropertiesOrPrimary());
        RelationValueColumnMetadata targetRelationValueColumnMetadata = relationValueFactory.create(entityMetadata, navigateMetadata.getTargetPropertiesOrPrimary(runtimeContext));
        HashMap<RelationValue, T> targetMap = new HashMap<RelationValue, T>();
        ArrayList easyTreeNodes = new ArrayList();
        for (T node : nodes) {
            RelationValue selfValue = selfRelationValueColumnMetadata.getRelationValue(node);
            RelationValue targetValue = targetRelationValueColumnMetadata.getRelationValue(node);
            targetMap.put(selfValue, node);
            easyTreeNodes.add(new EasyTreeNode<T>(node, selfValue, targetValue, navigateMetadata));
        }
        ArrayList<EasyTreeNode> roots = new ArrayList<EasyTreeNode>();
        Iterator ite = easyTreeNodes.iterator();
        while (ite.hasNext()) {
            EasyTreeNode node = (EasyTreeNode)ite.next();
            boolean root = !targetMap.containsKey(node.getTarget());
            if (!root) continue;
            roots.add(node);
            ite.remove();
        }
        roots.forEach(r -> EasyTreeUtil.setChildren(r, easyTreeNodes));
        return roots.stream().map(EasyTreeNode::getEntity).collect(Collectors.toList());
    }

    public static <T> void setChildren(EasyTreeNode<T> parent, List<EasyTreeNode<T>> nodes) {
        ArrayList<EasyTreeNode<EasyTreeNode>> children = new ArrayList<EasyTreeNode<EasyTreeNode>>();
        RelationValue parentId = parent.getSelf();
        Iterator<EasyTreeNode<T>> ite = nodes.iterator();
        while (ite.hasNext()) {
            EasyTreeNode<T> node = ite.next();
            if (!Objects.equals(node.getTarget(), parentId)) continue;
            children.add(node);
            ite.remove();
        }
        if (children.isEmpty()) {
            return;
        }
        parent.setChildren(children);
        children.forEach(m -> EasyTreeUtil.setChildren(m, nodes));
    }
}

