/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.processor;

import com.epam.healenium.model.HealedElement;
import com.epam.healenium.model.HealeniumSelectorImitatorDto;
import com.epam.healenium.model.HealingResult;
import com.epam.healenium.model.Locator;
import com.epam.healenium.processor.BaseProcessor;
import com.epam.healenium.treecomparing.Node;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImitateProcessor
extends BaseProcessor {
    private static final Logger log = LoggerFactory.getLogger(ImitateProcessor.class);

    public ImitateProcessor(BaseProcessor nextProcessor) {
        super(nextProcessor);
    }

    @Override
    public boolean validate() {
        if (this.context.getHealingResults().isEmpty()) {
            log.warn("New element locators have not been found.\nScore property = {} is bigger than healing's locator score", (Object)this.engine.getScoreCap());
            throw this.context.getNoSuchElementException();
        }
        return true;
    }

    @Override
    public void execute() {
        for (HealingResult healingResult : this.context.getHealingResults()) {
            Node targetNode = (Node)healingResult.getTargetNodes().get(0).getValue();
            Double score = healingResult.getTargetNodes().get(0).getScore();
            List choices = healingResult.getHealedElements().stream().map(HealedElement::getScored).collect(Collectors.toList());
            HealeniumSelectorImitatorDto imitatorDto = new HealeniumSelectorImitatorDto().setUserSelector(this.context.getUserLocator()).setTargetNode(targetNode);
            List<Locator> imitatedLocators = this.restClient.imitate(imitatorDto);
            this.engine.toLocator(imitatedLocators, score).ifPresent(by -> {
                choices.remove(0);
                choices.add(0, by);
            });
        }
    }
}

