/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium;

import com.epam.healenium.PageAwareBy;
import com.epam.healenium.annotation.DisableHealing;
import com.epam.healenium.client.RestClient;
import com.epam.healenium.model.Locator;
import com.epam.healenium.service.HealingService;
import com.epam.healenium.service.NodeService;
import com.epam.healenium.treecomparing.JsoupHTMLParser;
import com.epam.healenium.treecomparing.Node;
import com.epam.healenium.treecomparing.Scored;
import com.epam.healenium.utils.StackUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfHealingEngine {
    private static final Logger log = LoggerFactory.getLogger(SelfHealingEngine.class);
    private static final Config DEFAULT_CONFIG = ConfigFactory.systemProperties().withFallback((ConfigMergeable)ConfigFactory.load((String)"healenium.properties").withFallback((ConfigMergeable)ConfigFactory.load()));
    private final Config config;
    private final WebDriver webDriver;
    private final double scoreCap;
    private final boolean isProxy;
    private RestClient client;
    private NodeService nodeService;
    private HealingService healingService;

    public SelfHealingEngine(@NotNull WebDriver delegate, @NotNull Config config) {
        Config finalizedConfig = ConfigFactory.load((Config)config).withFallback((ConfigMergeable)DEFAULT_CONFIG);
        this.webDriver = delegate;
        this.config = finalizedConfig;
        this.scoreCap = finalizedConfig.getDouble("score-cap");
        this.isProxy = finalizedConfig.getBoolean("proxy");
    }

    public SelfHealingEngine(@NotNull WebDriver delegate) {
        this(delegate, DEFAULT_CONFIG);
    }

    public void saveElements(PageAwareBy by, List<WebElement> webElements) {
        List<List<Node>> nodesToSave = webElements.stream().map(this.nodeService::getNodePath).collect(Collectors.toList());
        this.saveNodes(by, nodesToSave);
    }

    public void saveNodes(PageAwareBy key, List<List<Node>> elementsToSave) {
        this.client.selectorsRequest(key.getBy(), new ArrayList<List<Node>>(elementsToSave), this.getCurrentUrl());
    }

    public Optional<Scored<By>> toLocator(List<Locator> imitatedLocators, Double score) {
        for (Locator imitatedLocator : imitatedLocators) {
            By locator = StackUtils.BY_MAP.get(imitatedLocator.getType()).apply(imitatedLocator.getValue());
            List elements = this.webDriver.findElements(locator);
            if (elements.size() != 1) continue;
            return Optional.of(new Scored(score.doubleValue(), (Object)locator));
        }
        return Optional.empty();
    }

    public String pageSource() {
        if (this.webDriver instanceof JavascriptExecutor) {
            return ((JavascriptExecutor)this.webDriver).executeScript("return document.body.outerHTML;", new Object[0]).toString();
        }
        return this.webDriver.getPageSource();
    }

    public Node parseTree(String tree) {
        return new JsoupHTMLParser().parse((InputStream)new ByteArrayInputStream(tree.getBytes(StandardCharsets.UTF_8)));
    }

    public boolean isHealingEnabled() {
        boolean isDisabled = StackUtils.isAnnotationPresent(DisableHealing.class);
        return this.config.getBoolean("heal-enabled") && !isDisabled;
    }

    public boolean isHealingBacklighted() {
        return this.config.getBoolean("backlight-healing");
    }

    public String getCurrentUrl() {
        return this.webDriver.getCurrentUrl().split("://")[1];
    }

    public byte[] captureScreen(WebElement element) {
        if (this.isHealingBacklighted()) {
            JavascriptExecutor jse = (JavascriptExecutor)this.webDriver;
            jse.executeScript("arguments[0].style.border='3px solid red'", new Object[]{element});
        }
        return (byte[])((TakesScreenshot)this.webDriver).getScreenshotAs(OutputType.BYTES);
    }

    public Config getConfig() {
        return this.config;
    }

    public WebDriver getWebDriver() {
        return this.webDriver;
    }

    public double getScoreCap() {
        return this.scoreCap;
    }

    public boolean isProxy() {
        return this.isProxy;
    }

    public RestClient getClient() {
        return this.client;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public HealingService getHealingService() {
        return this.healingService;
    }

    public void setClient(RestClient client) {
        this.client = client;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setHealingService(HealingService healingService) {
        this.healingService = healingService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SelfHealingEngine)) {
            return false;
        }
        SelfHealingEngine other = (SelfHealingEngine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getScoreCap(), other.getScoreCap()) != 0) {
            return false;
        }
        if (this.isProxy() != other.isProxy()) {
            return false;
        }
        Config this$config = this.getConfig();
        Config other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        WebDriver this$webDriver = this.getWebDriver();
        WebDriver other$webDriver = other.getWebDriver();
        if (this$webDriver == null ? other$webDriver != null : !this$webDriver.equals(other$webDriver)) {
            return false;
        }
        RestClient this$client = this.getClient();
        RestClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !((Object)this$client).equals(other$client)) {
            return false;
        }
        NodeService this$nodeService = this.getNodeService();
        NodeService other$nodeService = other.getNodeService();
        if (this$nodeService == null ? other$nodeService != null : !this$nodeService.equals(other$nodeService)) {
            return false;
        }
        HealingService this$healingService = this.getHealingService();
        HealingService other$healingService = other.getHealingService();
        return !(this$healingService == null ? other$healingService != null : !this$healingService.equals(other$healingService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SelfHealingEngine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $scoreCap = Double.doubleToLongBits(this.getScoreCap());
        result = result * 59 + (int)($scoreCap >>> 32 ^ $scoreCap);
        result = result * 59 + (this.isProxy() ? 79 : 97);
        Config $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        WebDriver $webDriver = this.getWebDriver();
        result = result * 59 + ($webDriver == null ? 43 : $webDriver.hashCode());
        RestClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : ((Object)$client).hashCode());
        NodeService $nodeService = this.getNodeService();
        result = result * 59 + ($nodeService == null ? 43 : $nodeService.hashCode());
        HealingService $healingService = this.getHealingService();
        result = result * 59 + ($healingService == null ? 43 : $healingService.hashCode());
        return result;
    }

    public String toString() {
        return "SelfHealingEngine(config=" + this.getConfig() + ", webDriver=" + this.getWebDriver() + ", scoreCap=" + this.getScoreCap() + ", isProxy=" + this.isProxy() + ", client=" + this.getClient() + ", nodeService=" + this.getNodeService() + ", healingService=" + this.getHealingService() + ")";
    }
}

