/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.elementcreators;

import com.epam.healenium.elementcreators.ElementCreator;
import com.epam.healenium.elementcreators.PositionElementCreator;
import com.epam.healenium.treecomparing.Node;
import java.util.ArrayDeque;

public class PathElementCreator
implements ElementCreator {
    private PositionElementCreator positionCreator = new PositionElementCreator();

    @Override
    public String create(Node node) {
        ArrayDeque<String> path = new ArrayDeque<String>();
        for (Node current = node; current != null; current = current.getParent()) {
            String item = current.getTag();
            if (this.hasSimilarNeighbours(current)) {
                item = item + this.positionCreator.create(current);
            }
            path.addFirst(item);
        }
        return String.join((CharSequence)" > ", path);
    }

    private boolean hasSimilarNeighbours(Node current) {
        Node parent = current.getParent();
        if (parent == null) {
            return false;
        }
        return parent.getChildren().stream().map(Node::getTag).filter(tag -> tag.equals(current.getTag())).count() > 1L;
    }
}

