/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.processor;

import com.epam.healenium.model.HealedElement;
import com.epam.healenium.model.HealingResult;
import com.epam.healenium.processor.BaseProcessor;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveHealingResultsProcessor
extends BaseProcessor {
    private static final Logger log = LoggerFactory.getLogger(SaveHealingResultsProcessor.class);

    public SaveHealingResultsProcessor(BaseProcessor nextProcessor) {
        super(nextProcessor);
    }

    @Override
    public void execute() {
        this.context.getHealingResults().forEach(this::enrichHealingResult);
        if (!this.context.getHealingResults().isEmpty()) {
            this.restClient.healRequest(this.context);
        }
    }

    public void enrichHealingResult(HealingResult healingResult) {
        HealedElement mainCandidate = healingResult.getHealedElements().get(0);
        WebElement mainHealedElement = mainCandidate.getElement();
        log.warn("Using healed locator: {}", mainCandidate.getScored());
        byte[] screenshot = this.engine.captureScreen(mainHealedElement);
        healingResult.setScreenshot(screenshot);
        this.context.getElements().add(mainHealedElement);
    }
}

