/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.utils;

import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.openqa.selenium.By;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StackUtils {
    private static final Logger log = LoggerFactory.getLogger((String)"healenium");
    public static final Map<String, Function<String, By>> BY_MAP = ImmutableMap.builder().put((Object)"By.className", By::className).put((Object)"By.cssSelector", By::cssSelector).put((Object)"By.xpath", By::xpath).put((Object)"By.tagName", By::tagName).put((Object)"By.name", By::name).put((Object)"By.partialLinkText", By::partialLinkText).put((Object)"By.linkText", By::linkText).put((Object)"By.id", By::id).build();

    public static boolean isAnnotationPresent(Class<? extends Annotation> aClass) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        return StackUtils.findAnnotatedInTrace(trace, aClass).isPresent();
    }

    public static Optional<StackTraceElement> getElementByClass(StackTraceElement[] elements, String targetClass) {
        return Arrays.stream(elements).filter(StackUtils.redundantPackages()).filter(element -> {
            String className = element.getClassName();
            String simpleClassName = className.substring(className.lastIndexOf(46) + 1);
            return simpleClassName.equals(targetClass);
        }).findFirst();
    }

    private static Optional<StackTraceElement> findAnnotatedInTrace(StackTraceElement[] elements, Class<? extends Annotation> clazz) {
        return Arrays.stream(elements).filter(StackUtils.redundantPackages()).filter(it -> {
            try {
                Class<?> aClass = Class.forName(it.getClassName());
                String methodName = it.getMethodName();
                return Arrays.stream(aClass.getMethods()).filter(m -> m.getName().equals(methodName)).anyMatch(m -> {
                    for (Annotation annotation : m.getDeclaredAnnotations()) {
                        if (!clazz.isInstance(annotation)) continue;
                        log.debug("Found at ={},{}", (Object)it.getClassName(), (Object)methodName);
                        return true;
                    }
                    return false;
                });
            }
            catch (ClassNotFoundException ex) {
                log.warn("Failed to check class: {}", (Object)it.getClassName());
                return false;
            }
        }).findFirst();
    }

    public static Predicate<StackTraceElement> redundantPackages() {
        return value -> {
            Stream<String> skippingPackageStream = Stream.of("java.base", "sun.reflect", "java.lang", "org.gradle", "org.junit", "java.util", "com.sun", "com.google", "jdk.internal", "org.openqa", "com.codeborne", "ru.yandex", "jdk.proxy2", "io.appium");
            return skippingPackageStream.noneMatch(s -> value.getClassName().startsWith((String)s));
        };
    }

    private StackUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

