/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.Map;
import java8.util.Objects;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SpecificationVersion;
import org.everit.json.schema.loader.internal.DefaultSchemaClient;
import org.everit.json.schema.regexp.JavaUtilRegexpFactory;
import org.everit.json.schema.regexp.RegexpFactory;

class LoaderConfig {
    final SchemaClient httpClient;
    final Map<String, FormatValidator> formatValidators;
    final SpecificationVersion specVersion;
    final boolean useDefaults;
    final boolean nullableSupport;
    final RegexpFactory regexpFactory;

    static LoaderConfig defaultV4Config() {
        return new LoaderConfig(new DefaultSchemaClient(), SpecificationVersion.DRAFT_4.defaultFormatValidators(), SpecificationVersion.DRAFT_4, false);
    }

    LoaderConfig(SchemaClient httpClient, Map<String, FormatValidator> formatValidators, SpecificationVersion specVersion, boolean useDefaults) {
        this(httpClient, formatValidators, specVersion, useDefaults, false, new JavaUtilRegexpFactory());
    }

    LoaderConfig(SchemaClient httpClient, Map<String, FormatValidator> formatValidators, SpecificationVersion specVersion, boolean useDefaults, boolean nullableSupport, RegexpFactory regexpFactory) {
        this.httpClient = (SchemaClient)Objects.requireNonNull((Object)httpClient, (String)"httpClient cannot be null");
        this.formatValidators = (Map)Objects.requireNonNull(formatValidators, (String)"formatValidators cannot be null");
        this.specVersion = (SpecificationVersion)((Object)Objects.requireNonNull((Object)((Object)specVersion), (String)"specVersion cannot be null"));
        this.useDefaults = useDefaults;
        this.nullableSupport = nullableSupport;
        this.regexpFactory = (RegexpFactory)Objects.requireNonNull((Object)regexpFactory, (String)"regexpFactory cannot be null");
    }
}

